"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoOutputSelector = exports.InoSelector = void 0;
const output_uri_1 = require("@theia/output/lib/common/output-uri");
/**
 * Exclusive "ino" document selector for monaco.
 */
exports.InoSelector = selectorOf('ino', 'c', 'cpp', 'h', 'hpp', 'pde');
function selectorOf(...languageId) {
    return languageId.map((language) => ({
        language,
        exclusive: true, // <-- this should make sure the custom formatter has higher precedence over the LS formatter.
    }));
}
/**
 * Selector for the `monaco` resource in the Arduino _Output_ channel.
 */
exports.ArduinoOutputSelector = {
    scheme: output_uri_1.OutputUri.SCHEME,
    pattern: '**/Arduino',
};
//# sourceMappingURL=selectors.js.map