"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.truncateLines = exports.messagesToLines = void 0;
const serial_monitor_send_output_1 = require("./serial-monitor-send-output");
function messagesToLines(messages, prevLines = [], charCount = 0, separator = '\n') {
    const linesToAdd = prevLines.length
        ? [prevLines[prevLines.length - 1]]
        : [{ message: '', lineLen: 0 }];
    if (!(Symbol.iterator in Object(messages)))
        return [prevLines, charCount];
    for (const message of messages) {
        const messageLen = message.length;
        charCount += messageLen;
        const lastLine = linesToAdd[linesToAdd.length - 1];
        // if the previous messages ends with "separator" add a new line
        if (lastLine.message.charAt(lastLine.message.length - 1) === separator) {
            linesToAdd.push({
                message,
                timestamp: new Date(),
                lineLen: messageLen,
            });
        }
        else {
            // concatenate to the last line
            linesToAdd[linesToAdd.length - 1].message += message;
            linesToAdd[linesToAdd.length - 1].lineLen += messageLen;
            if (!linesToAdd[linesToAdd.length - 1].timestamp) {
                linesToAdd[linesToAdd.length - 1].timestamp = new Date();
            }
        }
    }
    prevLines.splice(prevLines.length - 1, 1, ...linesToAdd);
    return [prevLines, charCount];
}
exports.messagesToLines = messagesToLines;
function truncateLines(lines, charCount, maxCharacters = serial_monitor_send_output_1.SerialMonitorOutput.MAX_CHARACTERS) {
    var _a, _b, _c;
    let charsToDelete = charCount - maxCharacters;
    let lineIndex = 0;
    while (charsToDelete > 0 || lineIndex > 0) {
        const firstLineLength = (_a = lines[lineIndex]) === null || _a === void 0 ? void 0 : _a.lineLen;
        if (charsToDelete >= firstLineLength) {
            // every time a full line to delete is found, move the index.
            lineIndex++;
            charsToDelete -= firstLineLength;
            charCount -= firstLineLength;
            continue;
        }
        // delete all previous lines
        lines.splice(0, lineIndex);
        lineIndex = 0;
        const newFirstLine = (_c = (_b = lines[0]) === null || _b === void 0 ? void 0 : _b.message) === null || _c === void 0 ? void 0 : _c.substring(charsToDelete);
        const deletedCharsCount = firstLineLength - newFirstLine.length;
        charCount -= deletedCharsCount;
        charsToDelete -= deletedCharsCount;
        lines[0].message = newFirstLine;
    }
    return [lines, charCount];
}
exports.truncateLines = truncateLines;
//# sourceMappingURL=monitor-utils.js.map