"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var MonitorViewContribution_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorViewContribution = exports.SerialMonitor = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/core/lib/browser");
const monitor_widget_1 = require("./monitor-widget");
const core_1 = require("@theia/core");
const arduino_toolbar_1 = require("../../toolbar/arduino-toolbar");
const arduino_menus_1 = require("../../menu/arduino-menus");
const common_1 = require("@theia/core/lib/common");
const monitor_model_1 = require("../../monitor-model");
const protocol_1 = require("../../../common/protocol");
var SerialMonitor;
(function (SerialMonitor) {
    let Commands;
    (function (Commands) {
        Commands.AUTOSCROLL = core_1.Command.toLocalizedCommand({
            id: 'serial-monitor-autoscroll',
            label: 'Autoscroll',
        }, 'arduino/serial/autoscroll');
        Commands.TIMESTAMP = core_1.Command.toLocalizedCommand({
            id: 'serial-monitor-timestamp',
            label: 'Timestamp',
        }, 'arduino/serial/timestamp');
        Commands.CLEAR_OUTPUT = core_1.Command.toLocalizedCommand({
            id: 'serial-monitor-clear-output',
            label: 'Clear Output',
            iconClass: (0, browser_1.codicon)('clear-all'),
        }, 'vscode/output.contribution/clearOutput.label');
    })(Commands = SerialMonitor.Commands || (SerialMonitor.Commands = {}));
})(SerialMonitor = exports.SerialMonitor || (exports.SerialMonitor = {}));
let MonitorViewContribution = MonitorViewContribution_1 = class MonitorViewContribution extends browser_1.AbstractViewContribution {
    constructor(model, monitorManagerProxy) {
        super({
            widgetId: monitor_widget_1.MonitorWidget.ID,
            widgetName: monitor_widget_1.MonitorWidget.LABEL,
            defaultWidgetOptions: {
                area: 'bottom',
            },
            toggleCommandId: MonitorViewContribution_1.TOGGLE_SERIAL_MONITOR,
            toggleKeybinding: 'CtrlCmd+Shift+M',
        });
        this.model = model;
        this.monitorManagerProxy = monitorManagerProxy;
        this.toggleAutoScroll = () => this.doToggleAutoScroll();
        this.toggleTimestamp = () => this.doToggleTimestamp();
        this.monitorManagerProxy.onMonitorShouldReset(() => this.reset());
    }
    registerMenus(menus) {
        if (this.toggleCommand) {
            menus.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__MAIN_GROUP, {
                commandId: this.toggleCommand.id,
                label: monitor_widget_1.MonitorWidget.LABEL,
                order: '5',
            });
        }
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: 'monitor-autoscroll',
            render: () => this.renderAutoScrollButton(),
            isVisible: (widget) => widget instanceof monitor_widget_1.MonitorWidget,
            onDidChange: this.model.onChange, // XXX: it's a hack. See: https://github.com/eclipse-theia/theia/pull/6696/
        });
        registry.registerItem({
            id: 'monitor-timestamp',
            render: () => this.renderTimestampButton(),
            isVisible: (widget) => widget instanceof monitor_widget_1.MonitorWidget,
            onDidChange: this.model.onChange, // XXX: it's a hack. See: https://github.com/eclipse-theia/theia/pull/6696/
        });
        registry.registerItem({
            id: SerialMonitor.Commands.CLEAR_OUTPUT.id,
            command: SerialMonitor.Commands.CLEAR_OUTPUT.id,
            tooltip: common_1.nls.localize('vscode/output.contribution/clearOutput.label', 'Clear Output'),
        });
    }
    registerCommands(commands) {
        commands.registerCommand(SerialMonitor.Commands.CLEAR_OUTPUT, {
            isEnabled: (widget) => widget instanceof monitor_widget_1.MonitorWidget,
            isVisible: (widget) => widget instanceof monitor_widget_1.MonitorWidget,
            execute: (widget) => {
                if (widget instanceof monitor_widget_1.MonitorWidget) {
                    widget.clearConsole();
                }
            },
        });
        if (this.toggleCommand) {
            commands.registerCommand(this.toggleCommand, {
                execute: () => this.toggle(),
            });
            commands.registerCommand({ id: MonitorViewContribution_1.TOGGLE_SERIAL_MONITOR_TOOLBAR }, {
                isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'right',
                execute: () => this.toggle(),
            });
        }
        commands.registerCommand({ id: MonitorViewContribution_1.RESET_SERIAL_MONITOR }, { execute: () => this.reset() });
    }
    async toggle() {
        const widget = this.tryGetWidget();
        if (widget) {
            widget.dispose();
        }
        else {
            await this.openView({ activate: true, reveal: true });
        }
    }
    async reset() {
        const widget = this.tryGetWidget();
        if (widget) {
            widget.dispose();
            await this.openView({ activate: true, reveal: true });
        }
    }
    renderAutoScrollButton() {
        return (React.createElement(React.Fragment, { key: "autoscroll-toolbar-item" },
            React.createElement("div", { title: common_1.nls.localize('vscode/output.contribution/toggleAutoScroll', 'Toggle Autoscroll'), className: `item enabled fa fa-angle-double-down arduino-monitor ${this.model.autoscroll ? 'toggled' : ''}`, onClick: this.toggleAutoScroll })));
    }
    async doToggleAutoScroll() {
        this.model.toggleAutoscroll();
    }
    renderTimestampButton() {
        return (React.createElement(React.Fragment, { key: "line-ending-toolbar-item" },
            React.createElement("div", { title: common_1.nls.localize('arduino/serial/toggleTimestamp', 'Toggle Timestamp'), className: `item enabled fa fa-clock-o arduino-monitor ${this.model.timestamp ? 'toggled' : ''}`, onClick: this.toggleTimestamp })));
    }
    async doToggleTimestamp() {
        this.model.toggleTimestamp();
    }
};
MonitorViewContribution.TOGGLE_SERIAL_MONITOR = monitor_widget_1.MonitorWidget.ID + ':toggle';
MonitorViewContribution.TOGGLE_SERIAL_MONITOR_TOOLBAR = monitor_widget_1.MonitorWidget.ID + ':toggle-toolbar';
MonitorViewContribution.RESET_SERIAL_MONITOR = monitor_widget_1.MonitorWidget.ID + ':reset';
MonitorViewContribution = MonitorViewContribution_1 = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(monitor_model_1.MonitorModel)),
    __param(1, (0, inversify_1.inject)(protocol_1.MonitorManagerProxyClient)),
    __metadata("design:paramtypes", [monitor_model_1.MonitorModel, Object])
], MonitorViewContribution);
exports.MonitorViewContribution = MonitorViewContribution;
//# sourceMappingURL=monitor-view-contribution.js.map