"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var MonitorWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const disposable_1 = require("@theia/core/lib/common/disposable");
const widgets_1 = require("@theia/core/lib/browser/widgets");
const arduino_select_1 = require("../../widgets/arduino-select");
const serial_monitor_send_input_1 = require("./serial-monitor-send-input");
const serial_monitor_send_output_1 = require("./serial-monitor-send-output");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const common_1 = require("@theia/core/lib/common");
const protocol_1 = require("../../../common/protocol");
const monitor_model_1 = require("../../monitor-model");
let MonitorWidget = MonitorWidget_1 = class MonitorWidget extends widgets_1.ReactWidget {
    constructor(monitorModel, monitorManagerProxy, boardsServiceProvider) {
        super();
        this.monitorModel = monitorModel;
        this.monitorManagerProxy = monitorManagerProxy;
        this.boardsServiceProvider = boardsServiceProvider;
        this.settings = {};
        /**
         * Guard against re-rendering the view after the close was requested.
         * See: https://github.com/eclipse-theia/theia/issues/6704
         */
        this.closing = false;
        this.clearOutputEmitter = new event_1.Emitter();
        this.onFocusResolved = (element) => {
            if (this.closing || !this.isAttached) {
                return;
            }
            this.focusNode = element;
            requestAnimationFrame(() => widgets_1.MessageLoop.sendMessage(this, widgets_1.Widget.Msg.ActivateRequest));
        };
        this.onSend = (value) => this.doSend(value);
        this.onChangeLineEnding = (option) => {
            this.monitorModel.lineEnding = option.value;
        };
        this.onChangeBaudRate = ({ value, }) => {
            this.getCurrentSettings().then(({ pluggableMonitorSettings }) => {
                if (!pluggableMonitorSettings || !pluggableMonitorSettings['baudrate'])
                    return;
                const baudRateSettings = pluggableMonitorSettings['baudrate'];
                baudRateSettings.selectedValue = value;
                this.monitorManagerProxy.changeSettings({ pluggableMonitorSettings });
            });
        };
        this.id = MonitorWidget_1.ID;
        this.title.label = MonitorWidget_1.LABEL;
        this.title.iconClass = 'monitor-tab-icon';
        this.title.closable = true;
        this.scrollOptions = undefined;
        this.toDispose.push(this.clearOutputEmitter);
        this.toDispose.push(disposable_1.Disposable.create(() => this.monitorManagerProxy.disconnect()));
    }
    onBeforeAttach(msg) {
        this.update();
        this.toDispose.push(this.monitorModel.onChange(() => this.update()));
        this.getCurrentSettings().then(this.onMonitorSettingsDidChange.bind(this));
        this.monitorManagerProxy.onMonitorSettingsDidChange(this.onMonitorSettingsDidChange.bind(this));
        this.monitorManagerProxy.startMonitor();
    }
    onMonitorSettingsDidChange(settings) {
        this.settings = Object.assign(Object.assign({}, this.settings), { pluggableMonitorSettings: Object.assign(Object.assign({}, this.settings.pluggableMonitorSettings), settings.pluggableMonitorSettings) });
        this.update();
    }
    clearConsole() {
        this.clearOutputEmitter.fire(undefined);
        this.update();
    }
    dispose() {
        super.dispose();
    }
    onCloseRequest(msg) {
        this.closing = true;
        super.onCloseRequest(msg);
    }
    onUpdateRequest(msg) {
        // TODO: `this.isAttached`
        // See: https://github.com/eclipse-theia/theia/issues/6704#issuecomment-562574713
        if (!this.closing && this.isAttached) {
            super.onUpdateRequest(msg);
        }
    }
    onResize(msg) {
        super.onResize(msg);
        this.widgetHeight = msg.height;
        this.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        (this.focusNode || this.node).focus();
    }
    get lineEndings() {
        return [
            {
                label: common_1.nls.localize('arduino/serial/noLineEndings', 'No Line Ending'),
                value: '',
            },
            {
                label: common_1.nls.localize('arduino/serial/newLine', 'New Line'),
                value: '\n',
            },
            {
                label: common_1.nls.localize('arduino/serial/carriageReturn', 'Carriage Return'),
                value: '\r',
            },
            {
                label: common_1.nls.localize('arduino/serial/newLineCarriageReturn', 'Both NL & CR'),
                value: '\r\n',
            },
        ];
    }
    getCurrentSettings() {
        const board = this.boardsServiceProvider.boardsConfig.selectedBoard;
        const port = this.boardsServiceProvider.boardsConfig.selectedPort;
        if (!board || !port) {
            return Promise.resolve(this.settings || {});
        }
        return this.monitorManagerProxy.getCurrentSettings(board, port);
    }
    render() {
        var _a;
        const baudrate = ((_a = this.settings) === null || _a === void 0 ? void 0 : _a.pluggableMonitorSettings)
            ? this.settings.pluggableMonitorSettings.baudrate
            : undefined;
        const baudrateOptions = baudrate === null || baudrate === void 0 ? void 0 : baudrate.values.map((b) => ({
            label: b + ' baud',
            value: b,
        }));
        const baudrateSelectedOption = baudrateOptions === null || baudrateOptions === void 0 ? void 0 : baudrateOptions.find((b) => b.value === (baudrate === null || baudrate === void 0 ? void 0 : baudrate.selectedValue));
        const lineEnding = this.lineEndings.find((item) => item.value === this.monitorModel.lineEnding) || this.lineEndings[1]; // Defaults to `\n`.
        return (React.createElement("div", { className: "serial-monitor" },
            React.createElement("div", { className: "head" },
                React.createElement("div", { className: "send" },
                    React.createElement(serial_monitor_send_input_1.SerialMonitorSendInput, { boardsServiceProvider: this.boardsServiceProvider, monitorModel: this.monitorModel, resolveFocus: this.onFocusResolved, onSend: this.onSend })),
                React.createElement("div", { className: "config" },
                    React.createElement("div", { className: "select" },
                        React.createElement(arduino_select_1.ArduinoSelect, { maxMenuHeight: this.widgetHeight - 40, options: this.lineEndings, value: lineEnding, onChange: this.onChangeLineEnding })),
                    baudrateOptions && baudrateSelectedOption && (React.createElement("div", { className: "select" },
                        React.createElement(arduino_select_1.ArduinoSelect, { className: "select", maxMenuHeight: this.widgetHeight - 40, options: baudrateOptions, value: baudrateSelectedOption, onChange: this.onChangeBaudRate }))))),
            React.createElement("div", { className: "body" },
                React.createElement(serial_monitor_send_output_1.SerialMonitorOutput, { monitorModel: this.monitorModel, monitorManagerProxy: this.monitorManagerProxy, clearConsoleEvent: this.clearOutputEmitter.event, height: Math.floor(this.widgetHeight - 50) }))));
    }
    async doSend(value) {
        this.monitorManagerProxy.send(value);
    }
};
MonitorWidget.LABEL = common_1.nls.localize('arduino/common/serialMonitor', 'Serial Monitor');
MonitorWidget.ID = 'serial-monitor';
MonitorWidget = MonitorWidget_1 = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(monitor_model_1.MonitorModel)),
    __param(1, (0, inversify_1.inject)(protocol_1.MonitorManagerProxyClient)),
    __param(2, (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider)),
    __metadata("design:paramtypes", [monitor_model_1.MonitorModel, Object, boards_service_provider_1.BoardsServiceProvider])
], MonitorWidget);
exports.MonitorWidget = MonitorWidget;
//# sourceMappingURL=monitor-widget.js.map