"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlotterFrontendContribution = exports.SerialPlotterContribution = void 0;
const theming_1 = require("@theia/core/lib/browser/theming");
const inversify_1 = require("@theia/core/shared/inversify");
const core_1 = require("@theia/core");
const arduino_menus_1 = require("../../menu/arduino-menus");
const contribution_1 = require("../../contributions/contribution");
const browser_1 = require("@theia/core/lib/browser");
const electron_1 = require("@theia/electron/shared/electron");
const protocol_1 = require("../../../common/protocol");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const monitor_model_1 = require("../../monitor-model");
const arduino_toolbar_1 = require("../../toolbar/arduino-toolbar");
const queryString = require('query-string');
var SerialPlotterContribution;
(function (SerialPlotterContribution) {
    let Commands;
    (function (Commands) {
        Commands.OPEN = core_1.Command.toLocalizedCommand({
            id: 'serial-plotter-open',
            label: 'Serial Plotter',
            category: 'Arduino',
        }, 'arduino/serial/openSerialPlotter');
        Commands.RESET = {
            id: 'serial-plotter-reset',
        };
        Commands.OPEN_TOOLBAR = {
            id: 'serial-plotter-open-toolbar',
        };
    })(Commands = SerialPlotterContribution.Commands || (SerialPlotterContribution.Commands = {}));
})(SerialPlotterContribution = exports.SerialPlotterContribution || (exports.SerialPlotterContribution = {}));
let PlotterFrontendContribution = class PlotterFrontendContribution extends contribution_1.Contribution {
    onStart(app) {
        this.url = new browser_1.Endpoint({ path: '/plotter' }).getRestUrl().toString();
        electron_1.ipcRenderer.on('CLOSE_CHILD_WINDOW', async () => {
            if (!!this.window) {
                this.window = null;
            }
        });
        this.monitorManagerProxy.onMonitorShouldReset(() => this.reset());
        return super.onStart(app);
    }
    registerCommands(registry) {
        registry.registerCommand(SerialPlotterContribution.Commands.OPEN, {
            execute: this.startPlotter.bind(this),
        });
        registry.registerCommand(SerialPlotterContribution.Commands.RESET, {
            execute: () => this.reset(),
        });
        registry.registerCommand({ id: SerialPlotterContribution.Commands.OPEN_TOOLBAR.id }, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'right',
            execute: this.startPlotter.bind(this),
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__MAIN_GROUP, {
            commandId: SerialPlotterContribution.Commands.OPEN.id,
            label: SerialPlotterContribution.Commands.OPEN.label,
            order: '7',
        });
    }
    async startPlotter() {
        await this.monitorManagerProxy.startMonitor();
        if (!!this.window) {
            this.window.focus();
            return;
        }
        const wsPort = this.monitorManagerProxy.getWebSocketPort();
        if (wsPort) {
            this.open(wsPort);
        }
        else {
            this.messageService.error(`Couldn't open serial plotter`);
        }
    }
    async open(wsPort) {
        const initConfig = {
            darkTheme: this.themeService.getCurrentTheme().type === 'dark',
            wsPort,
            serialPort: this.model.serialPort,
        };
        const urlWithParams = queryString.stringifyUrl({
            url: this.url,
            query: initConfig,
        }, { arrayFormat: 'comma' });
        this.window = window.open(urlWithParams, 'serialPlotter');
    }
    async reset() {
        if (!!this.window) {
            this.window.close();
            await this.startPlotter();
        }
    }
};
__decorate([
    (0, inversify_1.inject)(monitor_model_1.MonitorModel),
    __metadata("design:type", monitor_model_1.MonitorModel)
], PlotterFrontendContribution.prototype, "model", void 0);
__decorate([
    (0, inversify_1.inject)(theming_1.ThemeService),
    __metadata("design:type", theming_1.ThemeService)
], PlotterFrontendContribution.prototype, "themeService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.MonitorManagerProxyClient),
    __metadata("design:type", Object)
], PlotterFrontendContribution.prototype, "monitorManagerProxy", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], PlotterFrontendContribution.prototype, "boardsServiceProvider", void 0);
PlotterFrontendContribution = __decorate([
    (0, inversify_1.injectable)()
], PlotterFrontendContribution);
exports.PlotterFrontendContribution = PlotterFrontendContribution;
//# sourceMappingURL=plotter-frontend-contribution.js.map