"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var StorageWrapper_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageWrapper = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const storage_service_1 = require("@theia/core/lib/browser/storage-service");
/**
 * This is a workaround to break cycles in the dependency injection. Provides commands for `setData` and `getData`.
 */
let StorageWrapper = StorageWrapper_1 = class StorageWrapper {
    registerCommands(commands) {
        commands.registerCommand(StorageWrapper_1.Commands.GET_DATA, {
            execute: (key, defaultValue) => this.storageService.getData(key, defaultValue),
        });
        commands.registerCommand(StorageWrapper_1.Commands.SET_DATA, {
            execute: (key, value) => this.storageService.setData(key, value),
        });
    }
};
__decorate([
    (0, inversify_1.inject)(storage_service_1.StorageService),
    __metadata("design:type", Object)
], StorageWrapper.prototype, "storageService", void 0);
StorageWrapper = StorageWrapper_1 = __decorate([
    (0, inversify_1.injectable)()
], StorageWrapper);
exports.StorageWrapper = StorageWrapper;
(function (StorageWrapper) {
    let Commands;
    (function (Commands) {
        Commands.SET_DATA = {
            id: 'arduino-store-wrapper-set',
        };
        Commands.GET_DATA = {
            id: 'arduino-store-wrapper-get',
        };
    })(Commands = StorageWrapper.Commands || (StorageWrapper.Commands = {}));
})(StorageWrapper = exports.StorageWrapper || (exports.StorageWrapper = {}));
exports.StorageWrapper = StorageWrapper;
//# sourceMappingURL=storage-wrapper.js.map