"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockPanelRenderer = exports.ApplicationShell = void 0;
const browser_1 = require("@theia/core/lib/browser");
const connection_status_service_1 = require("@theia/core/lib/browser/connection-status-service");
const nls_1 = require("@theia/core/lib/common/nls");
const message_service_1 = require("@theia/core/lib/common/message-service");
const inversify_1 = require("@theia/core/shared/inversify");
const tab_bars_1 = require("./tab-bars");
let ApplicationShell = class ApplicationShell extends browser_1.ApplicationShell {
    async addWidget(widget, options = {}) {
        // By default, Theia open a widget **next** to the currently active in the target area.
        // Instead of this logic, we want to open the new widget after the last of the target area.
        if (!widget.id) {
            console.error('Widgets added to the application shell must have a unique id property.');
            return;
        }
        let ref = options.ref;
        const area = options.area || 'main';
        if (!ref && (area === 'main' || area === 'bottom')) {
            const tabBar = this.getTabBarFor(area);
            if (tabBar) {
                const last = tabBar.titles[tabBar.titles.length - 1];
                if (last) {
                    ref = last.owner;
                }
            }
        }
        return super.addWidget(widget, Object.assign(Object.assign({}, options), { ref }));
    }
    handleEvent() {
        // NOOP, dragging has been disabled
        return false;
    }
    // Avoid hiding top panel as we use it for arduino toolbar
    createTopPanel() {
        const topPanel = super.createTopPanel();
        topPanel.show();
        return topPanel;
    }
    async saveAll(options) {
        if (this.connectionStatusService.currentStatus === connection_status_service_1.ConnectionStatus.OFFLINE) {
            this.messageService.error(nls_1.nls.localize('theia/core/couldNotSave', 'Could not save the sketch. Please copy your unsaved work into your favorite text editor, and restart the IDE.'));
            return; // Theia does not reject on failed save: https://github.com/eclipse-theia/theia/pull/8803
        }
        return super.saveAll(options);
    }
};
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], ApplicationShell.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(connection_status_service_1.ConnectionStatusService),
    __metadata("design:type", Object)
], ApplicationShell.prototype, "connectionStatusService", void 0);
ApplicationShell = __decorate([
    (0, inversify_1.injectable)()
], ApplicationShell);
exports.ApplicationShell = ApplicationShell;
class DockPanelRenderer extends browser_1.DockPanelRenderer {
    createTabBar() {
        const renderer = this.tabBarRendererFactory();
        // `ToolbarAwareTabBar` is from IDE2 and not from Theia. Check the imports.
        const tabBar = new tab_bars_1.ToolbarAwareTabBar(this.tabBarToolbarRegistry, this.tabBarToolbarFactory, this.breadcrumbsRendererFactory, {
            renderer,
            // Scroll bar options
            handlers: ['drag-thumb', 'keyboard', 'wheel', 'touch'],
            useBothWheelAxes: true,
            scrollXMarginOffset: 4,
            suppressScrollY: true,
        });
        this.tabBarClasses.forEach((c) => tabBar.addClass(c));
        renderer.tabBar = tabBar;
        tabBar.disposed.connect(() => renderer.dispose());
        renderer.contextMenuPath = browser_1.SHELL_TABBAR_CONTEXT_MENU;
        tabBar.currentChanged.connect(this.onCurrentTabChanged, this);
        return tabBar;
    }
}
exports.DockPanelRenderer = DockPanelRenderer;
const originalHandleEvent = browser_1.DockPanel.prototype.handleEvent;
browser_1.DockPanel.prototype.handleEvent = function (event) {
    switch (event.type) {
        case 'p-dragenter':
        case 'p-dragleave':
        case 'p-dragover':
        case 'p-drop':
            return;
    }
    originalHandleEvent.bind(this)(event);
};
//# sourceMappingURL=application-shell.js.map