"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("../../../../src/browser/style/browser-menu.css");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_menu_plugin_1 = require("@theia/core/lib/browser/menu/browser-menu-plugin");
const main_menu_manager_1 = require("../../../common/main-menu-manager");
const browser_menu_plugin_2 = require("./browser-menu-plugin");
const browser_main_menu_factory_1 = require("./browser-main-menu-factory");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(browser_main_menu_factory_1.BrowserMainMenuFactory).toSelf().inSingletonScope();
    bind(main_menu_manager_1.MainMenuManager).toService(browser_main_menu_factory_1.BrowserMainMenuFactory);
    rebind(browser_menu_plugin_1.BrowserMainMenuFactory).toService(browser_main_menu_factory_1.BrowserMainMenuFactory);
    rebind(browser_menu_plugin_1.BrowserMenuBarContribution)
        .to(browser_menu_plugin_2.ArduinoMenuContribution)
        .inSingletonScope();
});
//# sourceMappingURL=browser-menu-module.js.map