"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonFrontendContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
let CommonFrontendContribution = class CommonFrontendContribution extends common_frontend_contribution_1.CommonFrontendContribution {
    registerCommands(commandRegistry) {
        super.registerCommands(commandRegistry);
        for (const command of [
            common_frontend_contribution_1.CommonCommands.CONFIGURE_DISPLAY_LANGUAGE,
            common_frontend_contribution_1.CommonCommands.CLOSE_TAB,
            common_frontend_contribution_1.CommonCommands.CLOSE_SAVED_TABS,
            common_frontend_contribution_1.CommonCommands.CLOSE_OTHER_TABS,
            common_frontend_contribution_1.CommonCommands.CLOSE_ALL_TABS,
            common_frontend_contribution_1.CommonCommands.COLLAPSE_PANEL,
            common_frontend_contribution_1.CommonCommands.TOGGLE_MAXIMIZED,
            common_frontend_contribution_1.CommonCommands.PIN_TAB,
            common_frontend_contribution_1.CommonCommands.UNPIN_TAB,
            common_frontend_contribution_1.CommonCommands.NEW_FILE,
        ]) {
            commandRegistry.unregisterCommand(command);
        }
    }
    registerMenus(registry) {
        super.registerMenus(registry);
        for (const command of [
            common_frontend_contribution_1.CommonCommands.SAVE,
            common_frontend_contribution_1.CommonCommands.SAVE_ALL,
            common_frontend_contribution_1.CommonCommands.CUT,
            common_frontend_contribution_1.CommonCommands.COPY,
            common_frontend_contribution_1.CommonCommands.PASTE,
            common_frontend_contribution_1.CommonCommands.COPY_PATH,
            common_frontend_contribution_1.CommonCommands.FIND,
            common_frontend_contribution_1.CommonCommands.REPLACE,
            common_frontend_contribution_1.CommonCommands.AUTO_SAVE,
            common_frontend_contribution_1.CommonCommands.OPEN_PREFERENCES,
            common_frontend_contribution_1.CommonCommands.SELECT_ICON_THEME,
            common_frontend_contribution_1.CommonCommands.SELECT_COLOR_THEME,
            common_frontend_contribution_1.CommonCommands.ABOUT_COMMAND,
            common_frontend_contribution_1.CommonCommands.SAVE_WITHOUT_FORMATTING, // Patched for https://github.com/eclipse-theia/theia/pull/8877
        ]) {
            registry.unregisterMenuAction(command);
        }
    }
    onWillStop() {
        // This is NOOP here. All window close and app quit requests are handled in the `Close` contribution.
        return undefined;
    }
};
CommonFrontendContribution = __decorate([
    (0, inversify_1.injectable)()
], CommonFrontendContribution);
exports.CommonFrontendContribution = CommonFrontendContribution;
//# sourceMappingURL=common-frontend-contribution.js.map