"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabBarDecoratorService = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const logger_1 = require("@theia/core/lib/common/logger");
const browser_1 = require("@theia/editor/lib/browser");
const tab_bar_decorator_1 = require("@theia/core/lib/browser/shell/tab-bar-decorator");
const config_service_1 = require("../../../common/protocol/config-service");
let TabBarDecoratorService = class TabBarDecoratorService extends tab_bar_decorator_1.TabBarDecoratorService {
    init() {
        this.configService
            .getConfiguration()
            .then(({ dataDirUri }) => (this.dataDirUri = new uri_1.default(dataDirUri)))
            .catch((err) => this.logger.error(`Failed to determine the data directory: ${err}`));
    }
    getDecorations(title) {
        if (title.owner instanceof browser_1.EditorWidget) {
            const editor = title.owner.editor;
            if (this.dataDirUri && this.dataDirUri.isEqualOrParent(editor.uri)) {
                return [];
            }
        }
        return super.getDecorations(title);
    }
};
__decorate([
    (0, inversify_1.inject)(config_service_1.ConfigService),
    __metadata("design:type", Object)
], TabBarDecoratorService.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(logger_1.ILogger),
    __metadata("design:type", Object)
], TabBarDecoratorService.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TabBarDecoratorService.prototype, "init", null);
TabBarDecoratorService = __decorate([
    (0, inversify_1.injectable)()
], TabBarDecoratorService);
exports.TabBarDecoratorService = TabBarDecoratorService;
//# sourceMappingURL=tab-bar-decorator.js.map