"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolbarAwareTabBar = exports.TabBarRenderer = void 0;
const saveable_1 = require("@theia/core/lib/browser/saveable");
const tab_bars_1 = require("@theia/core/lib/browser/shell/tab-bars");
const debounce = require("lodash.debounce");
class TabBarRenderer extends tab_bars_1.TabBarRenderer {
    constructor() {
        super(...arguments);
        this.handleContextMenuEvent = () => {
            // NOOP
            // Context menus are empty, so they have been removed
        };
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    createTabClass(data) {
        let className = super.createTabClass(data);
        if (!data.title.closable && saveable_1.Saveable.isDirty(data.title.owner)) {
            className += ' p-mod-closable';
        }
        return className;
    }
}
exports.TabBarRenderer = TabBarRenderer;
class ToolbarAwareTabBar extends tab_bars_1.ToolbarAwareTabBar {
    constructor() {
        super(...arguments);
        this.doUpdateToolbar = debounce(() => super.updateToolbar(), 500);
    }
    async updateBreadcrumbs() {
        // NOOP
        // IDE2 does not use breadcrumbs.
    }
    updateToolbar() {
        // Unlike Theia, IDE2 debounces the toolbar updates with 500ms
        this.doUpdateToolbar();
    }
}
exports.ToolbarAwareTabBar = ToolbarAwareTabBar;
//# sourceMappingURL=tab-bars.js.map