"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WidgetManager = void 0;
const widget_manager_1 = require("@theia/core/lib/browser/widget-manager");
const inversify_1 = require("@theia/core/shared/inversify");
const browser_1 = require("@theia/editor/lib/browser");
const output_widget_1 = require("@theia/output/lib/browser/output-widget");
const deepEqual = require("deep-equal");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
let WidgetManager = class WidgetManager extends widget_manager_1.WidgetManager {
    init() {
        this.sketchesServiceClient.onCurrentSketchDidChange((sketch) => this.maybeSetWidgetUncloseable(sketch, ...Array.from(this.widgets.values())));
    }
    getOrCreateWidget(factoryId, options) {
        const unresolvedWidget = super.getOrCreateWidget(factoryId, options);
        unresolvedWidget.then(async (widget) => {
            const sketch = await this.sketchesServiceClient.currentSketch();
            this.maybeSetWidgetUncloseable(sketch, widget);
        });
        return unresolvedWidget;
    }
    maybeSetWidgetUncloseable(sketch, ...widgets) {
        const sketchFileUris = sketches_service_client_impl_1.CurrentSketch.isValid(sketch) &&
            new Set([sketch.mainFileUri, ...sketch.rootFolderFileUris]);
        for (const widget of widgets) {
            if (widget instanceof output_widget_1.OutputWidget) {
                this.setWidgetUncloseable(widget); // TODO: https://arduino.slack.com/archives/C01698YT7S4/p1598011990133700
            }
            else if (widget instanceof browser_1.EditorWidget) {
                // Make the editor un-closeable asynchronously.
                const uri = widget.editor.uri.toString();
                if (!!sketchFileUris && sketchFileUris.has(uri)) {
                    this.setWidgetUncloseable(widget);
                }
            }
        }
    }
    setWidgetUncloseable(widget) {
        const { title } = widget;
        if (title.closable) {
            title.closable = false;
        }
        // Show the dirty indicator on uncloseable widgets when hovering over the title. Instead of showing the `X` for close.
        const uncloseableClass = 'a-mod-uncloseable';
        if (!title.className.includes(uncloseableClass)) {
            title.className += title.className + ` ${uncloseableClass}`;
        }
    }
    /**
     * Customized to find any existing widget based on `options` deepEquals instead of string equals.
     * See https://github.com/eclipse-theia/theia/issues/11309.
     */
    doGetWidget(key) {
        const pendingWidget = this.findExistingWidget(key);
        if (pendingWidget) {
            return pendingWidget;
        }
        return undefined;
    }
    findExistingWidget(key) {
        const parsed = this.parseJson(key);
        for (const [candidateKey, widget] of [
            ...this.widgetPromises.entries(),
            ...this.pendingWidgetPromises.entries(),
        ]) {
            const candidate = this.parseJson(candidateKey);
            if (deepEqual(candidate, parsed)) {
                return widget;
            }
        }
        return undefined;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    parseJson(json) {
        try {
            return JSON.parse(json);
        }
        catch (err) {
            console.log(`Failed to parse JSON: <${json}>.`, err);
            throw err;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], WidgetManager.prototype, "sketchesServiceClient", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], WidgetManager.prototype, "init", null);
WidgetManager = __decorate([
    (0, inversify_1.injectable)()
], WidgetManager);
exports.WidgetManager = WidgetManager;
//# sourceMappingURL=widget-manager.js.map