"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugConfigurationManager = void 0;
const debounce = require("p-debounce");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const event_1 = require("@theia/core/lib/common/event");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const debug_configuration_manager_1 = require("@theia/debug/lib/browser/debug-configuration-manager");
const protocol_1 = require("../../../common/protocol");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const debug_configuration_model_1 = require("./debug-configuration-model");
const files_1 = require("@theia/filesystem/lib/common/files");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
let DebugConfigurationManager = class DebugConfigurationManager extends debug_configuration_manager_1.DebugConfigurationManager {
    constructor() {
        super(...arguments);
        this.onTempContentDidChangeEmitter = new event_1.Emitter();
        this.updateModels = debounce(async () => {
            await this.appStateService.reachedState('ready');
            const roots = await this.workspaceService.roots;
            const toDelete = new Set(this.models.keys());
            for (const rootStat of roots) {
                const key = rootStat.resource.toString();
                toDelete.delete(key);
                if (!this.models.has(key)) {
                    const tempContent = await this.getTempLaunchJsonContent();
                    if (!tempContent) {
                        continue;
                    }
                    const configurations = tempContent instanceof uri_1.default ? [] : tempContent.configurations;
                    const uri = tempContent instanceof uri_1.default ? undefined : tempContent.uri;
                    const model = new debug_configuration_model_1.DebugConfigurationModel(key, this.preferences, configurations, uri, this.onTempContentDidChange);
                    model.onDidChange(() => this.updateCurrent());
                    model.onDispose(() => this.models.delete(key));
                    this.models.set(key, model);
                }
            }
            for (const uri of toDelete) {
                const model = this.models.get(uri);
                if (model) {
                    model.dispose();
                }
            }
            this.updateCurrent();
        }, 500);
    }
    get onTempContentDidChange() {
        return this.onTempContentDidChangeEmitter.event;
    }
    async init() {
        super.init();
        this.appStateService.reachedState('ready').then(async () => {
            const tempContent = await this.getTempLaunchJsonContent();
            if (!tempContent) {
                // No active sketch.
                return;
            }
            // Watch the file of the container folder.
            this.fileService.watch(tempContent instanceof uri_1.default ? tempContent : tempContent.uri);
            // Use the normalized temp folder name. We cannot compare Theia URIs here.
            // /var/folders/k3/d2fkvv1j16v3_rz93k7f74180000gn/T/arduino-ide2-a0337d47f86b24a51df3dbcf2cc17925/launch.json
            // /private/var/folders/k3/d2fkvv1j16v3_rz93k7f74180000gn/T/arduino-ide2-A0337D47F86B24A51DF3DBCF2CC17925/launch.json
            const tempFolderName = (tempContent instanceof uri_1.default ? tempContent : tempContent.uri.parent).path.base.toLowerCase();
            this.fileService.onDidFilesChange((event) => {
                for (const { resource } of event.changes) {
                    if (resource.path.base === 'launch.json' &&
                        resource.parent.path.base.toLowerCase() === tempFolderName) {
                        this.getTempLaunchJsonContent().then((config) => {
                            if (config && !(config instanceof uri_1.default)) {
                                this.onTempContentDidChangeEmitter.fire(config);
                            }
                        });
                        break;
                    }
                }
            });
            this.updateModels();
        });
    }
    async getTempLaunchJsonContent() {
        const sketch = await this.sketchesServiceClient.currentSketch();
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return undefined;
        }
        const uri = await this.sketchesService.getIdeTempFolderUri(sketch);
        const tempFolderUri = new uri_1.default(uri);
        await this.fileService.createFolder(tempFolderUri);
        try {
            const uri = tempFolderUri.resolve('launch.json');
            const { value } = await this.fileService.read(uri);
            const configurations = debug_configuration_model_1.DebugConfigurationModel.parse(JSON.parse(value));
            return { uri, configurations };
        }
        catch (err) {
            if (err instanceof files_1.FileOperationError &&
                err.fileOperationResult === 1 /* FILE_NOT_FOUND */) {
                return tempFolderUri;
            }
            console.error('Could not load debug configuration from IDE2 temp folder.', err);
            throw err;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], DebugConfigurationManager.prototype, "sketchesService", void 0);
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], DebugConfigurationManager.prototype, "sketchesServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], DebugConfigurationManager.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], DebugConfigurationManager.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DebugConfigurationManager.prototype, "init", null);
DebugConfigurationManager = __decorate([
    (0, inversify_1.injectable)()
], DebugConfigurationManager);
exports.DebugConfigurationManager = DebugConfigurationManager;
//# sourceMappingURL=debug-configuration-manager.js.map