"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorCommandContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const editor_command_1 = require("@theia/editor/lib/browser/editor-command");
let EditorCommandContribution = class EditorCommandContribution extends editor_command_1.EditorCommandContribution {
    init() {
        // Workaround for https://github.com/eclipse-theia/theia/issues/8722.
        this.editorPreferences.onPreferenceChanged(({ preferenceName, newValue, oldValue }) => {
            if (preferenceName === 'files.autoSave') {
                const autoSaveWasOnBeforeChange = !oldValue || oldValue !== 'off';
                const autoSaveIsOnAfterChange = !newValue || newValue !== 'off';
                if (!autoSaveWasOnBeforeChange && autoSaveIsOnAfterChange) {
                    this.shell.saveAll();
                }
            }
        });
    }
};
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], EditorCommandContribution.prototype, "init", null);
EditorCommandContribution = __decorate([
    (0, inversify_1.injectable)()
], EditorCommandContribution);
exports.EditorCommandContribution = EditorCommandContribution;
//# sourceMappingURL=editor-command.js.map