"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EditorWidgetFactory = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const editor_widget_factory_1 = require("@theia/editor/lib/browser/editor-widget-factory");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const protocol_1 = require("../../../common/protocol");
const common_1 = require("@theia/core/lib/common");
let EditorWidgetFactory = class EditorWidgetFactory extends editor_widget_factory_1.EditorWidgetFactory {
    async createEditor(uri, options) {
        const widget = await super.createEditor(uri, options);
        return this.maybeUpdateCaption(widget);
    }
    async maybeUpdateCaption(widget) {
        const sketch = await this.sketchesServiceClient.currentSketch();
        const { uri } = widget.editor;
        if (sketches_service_client_impl_1.CurrentSketch.isValid(sketch) && protocol_1.Sketch.isInSketch(uri, sketch)) {
            const isTemp = await this.sketchesService.isTemp(sketch);
            if (isTemp) {
                widget.title.caption = common_1.nls.localize('theia/editor/unsavedTitle', 'Unsaved – {0}', this.labelProvider.getName(uri));
            }
        }
        return widget;
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], EditorWidgetFactory.prototype, "sketchesService", void 0);
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], EditorWidgetFactory.prototype, "sketchesServiceClient", void 0);
EditorWidgetFactory = __decorate([
    (0, inversify_1.injectable)()
], EditorWidgetFactory);
exports.EditorWidgetFactory = EditorWidgetFactory;
//# sourceMappingURL=editor-widget-factory.js.map