"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProblemManager = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const core_1 = require("@theia/core");
const problem_manager_1 = require("@theia/markers/lib/browser/problem/problem-manager");
const config_service_1 = require("../../../common/protocol/config-service");
const debounce = require("lodash.debounce");
let ProblemManager = class ProblemManager extends problem_manager_1.ProblemManager {
    constructor() {
        super(...arguments);
        this.debouncedFireOnDidChangeMakers = debounce((uri) => this.onDidChangeMarkersEmitter.fire(uri), 500);
    }
    init() {
        super.init();
        this.configService
            .getConfiguration()
            .then(({ dataDirUri }) => (this.dataDirUri = new uri_1.default(dataDirUri)))
            .catch((err) => this.logger.error(`Failed to determine the data directory: ${err}`));
    }
    setMarkers(uri, owner, data) {
        if (this.dataDirUri && this.dataDirUri.isEqualOrParent(uri)) {
            return [];
        }
        return super.setMarkers(uri, owner, data);
    }
    fireOnDidChangeMarkers(uri) {
        this.debouncedFireOnDidChangeMakers(uri);
    }
};
__decorate([
    (0, inversify_1.inject)(config_service_1.ConfigService),
    __metadata("design:type", Object)
], ProblemManager.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    __metadata("design:type", Object)
], ProblemManager.prototype, "logger", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ProblemManager.prototype, "init", null);
ProblemManager = __decorate([
    (0, inversify_1.injectable)()
], ProblemManager);
exports.ProblemManager = ProblemManager;
//# sourceMappingURL=problem-manager.js.map