"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationsRenderer = void 0;
const React = require("@theia/core/shared/react");
const ReactDOM = require("@theia/core/shared/react-dom");
const inversify_1 = require("@theia/core/shared/inversify");
const notification_center_component_1 = require("./notification-center-component");
const notification_toasts_component_1 = require("./notification-toasts-component");
const notifications_renderer_1 = require("@theia/messages/lib/browser/notifications-renderer");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
let NotificationsRenderer = class NotificationsRenderer extends notifications_renderer_1.NotificationsRenderer {
    init() {
        // Unlike Theia, IDE2 renders the notification area only when the app is ready.
        this.appStateService.reachedState('ready').then(() => {
            this.createOverlayContainer();
            this.render();
        });
    }
    render() {
        ReactDOM.render(React.createElement("div", null,
            React.createElement(notification_toasts_component_1.NotificationToastsComponent, { manager: this.manager, corePreferences: this.corePreferences }),
            React.createElement(notification_center_component_1.NotificationCenterComponent, { manager: this.manager })), this.container);
    }
};
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], NotificationsRenderer.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], NotificationsRenderer.prototype, "init", null);
NotificationsRenderer = __decorate([
    (0, inversify_1.injectable)()
], NotificationsRenderer);
exports.NotificationsRenderer = NotificationsRenderer;
//# sourceMappingURL=notifications-renderer.js.map