"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonacoTextModelService = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const monaco_editor_model_1 = require("@theia/monaco/lib/browser/monaco-editor-model");
const monaco_text_model_service_1 = require("@theia/monaco/lib/browser/monaco-text-model-service");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
let MonacoTextModelService = class MonacoTextModelService extends monaco_text_model_service_1.MonacoTextModelService {
    async createModel(resource) {
        const factory = this.factories
            .getContributions()
            .find(({ scheme }) => resource.uri.scheme === scheme);
        const readOnly = this.sketchesServiceClient.isReadOnly(resource.uri);
        return factory
            ? factory.createModel(resource)
            : new MaybeReadonlyMonacoEditorModel(resource, this.m2p, this.p2m, this.logger, undefined, readOnly);
    }
};
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], MonacoTextModelService.prototype, "sketchesServiceClient", void 0);
MonacoTextModelService = __decorate([
    (0, inversify_1.injectable)()
], MonacoTextModelService);
exports.MonacoTextModelService = MonacoTextModelService;
// https://github.com/eclipse-theia/theia/pull/8491
class SilentMonacoEditorModel extends monaco_editor_model_1.MonacoEditorModel {
    trace(loggable) {
        if (this.logger) {
            this.logger.trace((log) => loggable((message, ...params) => log(message, ...params, this.resource.uri.toString(true))));
        }
    }
}
class MaybeReadonlyMonacoEditorModel extends SilentMonacoEditorModel {
    constructor(resource, m2p, p2m, logger, editorPreferences, _readOnly) {
        super(resource, m2p, p2m, logger, editorPreferences);
        this.resource = resource;
        this.m2p = m2p;
        this.p2m = p2m;
        this.logger = logger;
        this.editorPreferences = editorPreferences;
        this._readOnly = _readOnly;
    }
    get readOnly() {
        if (typeof this._readOnly === 'boolean') {
            return this._readOnly;
        }
        return this.resource.saveContents === undefined;
    }
    setDirty(dirty) {
        if (this._readOnly === true) {
            // NOOP
            return;
        }
        if (dirty === this._dirty) {
            return;
        }
        this._dirty = dirty;
        if (dirty === false) {
            this.updateSavedVersionId();
        }
        this.onDirtyChangedEmitter.fire(undefined);
    }
}
//# sourceMappingURL=monaco-text-model-service.js.map