"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileNavigatorContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const workspace_commands_1 = require("@theia/workspace/lib/browser/workspace-commands");
const navigator_contribution_1 = require("@theia/navigator/lib/browser/navigator-contribution");
const navigator_preferences_1 = require("@theia/navigator/lib/browser/navigator-preferences");
const opener_service_1 = require("@theia/core/lib/browser/opener-service");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const navigator_filter_1 = require("@theia/navigator/lib/browser/navigator-filter");
const workspace_preferences_1 = require("@theia/workspace/lib/browser/workspace-preferences");
let FileNavigatorContribution = class FileNavigatorContribution extends navigator_contribution_1.FileNavigatorContribution {
    constructor(fileNavigatorPreferences, openerService, fileNavigatorFilter, workspaceService, workspacePreferences) {
        super(fileNavigatorPreferences, openerService, fileNavigatorFilter, workspaceService, workspacePreferences);
        this.fileNavigatorPreferences = fileNavigatorPreferences;
        this.openerService = openerService;
        this.fileNavigatorFilter = fileNavigatorFilter;
        this.workspaceService = workspaceService;
        this.workspacePreferences = workspacePreferences;
        this.options.defaultWidgetOptions.rank = 1;
    }
    async initializeLayout(app) {
        // NOOP
    }
    registerKeybindings(registry) {
        super.registerKeybindings(registry);
        [workspace_commands_1.WorkspaceCommands.FILE_RENAME, workspace_commands_1.WorkspaceCommands.FILE_DELETE].forEach(registry.unregisterKeybinding.bind(registry));
    }
};
FileNavigatorContribution = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(navigator_preferences_1.FileNavigatorPreferences)),
    __param(1, (0, inversify_1.inject)(opener_service_1.OpenerService)),
    __param(2, (0, inversify_1.inject)(navigator_filter_1.FileNavigatorFilter)),
    __param(3, (0, inversify_1.inject)(workspace_service_1.WorkspaceService)),
    __param(4, (0, inversify_1.inject)(workspace_preferences_1.WorkspacePreferences)),
    __metadata("design:paramtypes", [Object, Object, navigator_filter_1.FileNavigatorFilter,
        workspace_service_1.WorkspaceService, Object])
], FileNavigatorContribution);
exports.FileNavigatorContribution = FileNavigatorContribution;
//# sourceMappingURL=navigator-contribution.js.map