"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputChannel = exports.OutputChannelManager = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const output_uri_1 = require("@theia/output/lib/common/output-uri");
const output_channel_1 = require("@theia/output/lib/browser/output-channel");
let OutputChannelManager = class OutputChannelManager extends output_channel_1.OutputChannelManager {
    getChannel(name) {
        const existing = this.channels.get(name);
        if (existing) {
            return existing;
        }
        // We have to register the resource first, because `textModelService#createModelReference` will require it
        // right after creating the monaco.editor.ITextModel.
        // All `append` and `appendLine` will be deferred until the underlying text-model instantiation.
        let resource = this.resources.get(name);
        if (!resource) {
            const uri = output_uri_1.OutputUri.create(name);
            const editorModelRef = new promise_util_1.Deferred();
            resource = this.createResource({ uri, editorModelRef });
            this.resources.set(name, resource);
            this.textModelService
                .createModelReference(uri)
                .then((ref) => editorModelRef.resolve(ref));
        }
        const channel = new OutputChannel(resource, this.preferences);
        this.channels.set(name, channel);
        this.toDisposeOnChannelDeletion.set(name, this.registerListeners(channel));
        this.channelAddedEmitter.fire(channel);
        if (!this.selectedChannel) {
            this.selectedChannel = channel;
        }
        return channel;
    }
    async contentOfChannel(name) {
        const resource = this.resources.get(name);
        if (resource) {
            return resource.readContents();
        }
        return undefined;
    }
};
OutputChannelManager = __decorate([
    (0, inversify_1.injectable)()
], OutputChannelManager);
exports.OutputChannelManager = OutputChannelManager;
class OutputChannel extends output_channel_1.OutputChannel {
    dispose() {
        super.dispose();
        if (this.disposed) {
            const textModifyQueue = this.textModifyQueue;
            textModifyQueue.pause();
            textModifyQueue.clear();
        }
    }
}
exports.OutputChannel = OutputChannel;
//# sourceMappingURL=output-channel.js.map