"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedPluginSupport = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const hosted_plugin_1 = require("@theia/plugin-ext/lib/hosted/browser/hosted-plugin");
let HostedPluginSupport = class HostedPluginSupport extends hosted_plugin_1.HostedPluginSupport {
    constructor() {
        super(...arguments);
        this.onDidLoadEmitter = new core_1.Emitter();
        this.onDidCloseConnectionEmitter = new core_1.Emitter();
    }
    onStart(container) {
        super.onStart(container);
        this.hostedPluginServer.onDidCloseConnection(() => this.onDidCloseConnectionEmitter.fire());
    }
    async doLoad() {
        await super.doLoad();
        this.onDidLoadEmitter.fire(); // Unlike Theia, IDE2 fires an event after loading the VS Code extensions.
    }
    get onDidLoad() {
        return this.onDidLoadEmitter.event;
    }
    get onDidCloseConnection() {
        return this.onDidCloseConnectionEmitter.event;
    }
    get hostedPluginServer() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return this.server;
    }
};
HostedPluginSupport = __decorate([
    (0, inversify_1.injectable)()
], HostedPluginSupport);
exports.HostedPluginSupport = HostedPluginSupport;
//# sourceMappingURL=hosted-plugin.js.map