"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceTreeGenerator = void 0;
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const inversify_1 = require("@theia/core/shared/inversify");
const preference_tree_generator_1 = require("@theia/preferences/lib/browser/util/preference-tree-generator");
let PreferenceTreeGenerator = class PreferenceTreeGenerator extends preference_tree_generator_1.PreferenceTreeGenerator {
    constructor() {
        super(...arguments);
        this.shouldHandleChangedSchemaOnReady = false;
    }
    async init() {
        this.appStateService.onStateChanged((state) => {
            this.state = state;
            // manually trigger a model (and UI) refresh if it was requested during the startup phase.
            if (this.state === 'ready' && this.shouldHandleChangedSchemaOnReady) {
                this.doHandleChangedSchema();
            }
        });
        return super.init();
    }
    doHandleChangedSchema() {
        if (this.state === 'ready') {
            super.doHandleChangedSchema();
        }
        // don't do anything until the app is `ready`, then invoke `doHandleChangedSchema`.
        this.shouldHandleChangedSchemaOnReady = true;
    }
    generateTree() {
        if (this.state === 'ready') {
            return super.generateTree();
        }
        // always create an empty root when the app is not ready.
        this._root = this.createRootNode();
        return this._root;
    }
};
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], PreferenceTreeGenerator.prototype, "appStateService", void 0);
PreferenceTreeGenerator = __decorate([
    (0, inversify_1.injectable)()
], PreferenceTreeGenerator);
exports.PreferenceTreeGenerator = PreferenceTreeGenerator;
//# sourceMappingURL=preference-tree-generator.js.map