"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchInWorkspaceResultTreeWidget = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const search_in_workspace_result_tree_widget_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-result-tree-widget");
const resource_1 = require("@theia/core/lib/common/resource");
/**
 * Workaround for https://github.com/eclipse-theia/theia/pull/9192/.
 */
let SearchInWorkspaceResultTreeWidget = class SearchInWorkspaceResultTreeWidget extends search_in_workspace_result_tree_widget_1.SearchInWorkspaceResultTreeWidget {
    async createReplacePreview(node) {
        const fileUri = new uri_1.default(node.fileUri).withScheme('file');
        const openedEditor = this.editorManager.all.find(({ editor }) => editor.uri.toString() === fileUri.toString());
        let content;
        if (openedEditor) {
            content = openedEditor.editor.document.getText();
        }
        else {
            const resource = await this.fileResourceResolver.resolve(fileUri);
            content = await resource.readContents();
        }
        const lines = content.split('\n');
        node.children.map((l) => {
            const leftPositionedNodes = node.children.filter((rl) => rl.line === l.line && rl.character < l.character);
            const diff = (this._replaceTerm.length - this.searchTerm.length) *
                leftPositionedNodes.length;
            const start = lines[l.line - 1].substr(0, l.character - 1 + diff);
            const end = lines[l.line - 1].substr(l.character - 1 + diff + l.length);
            lines[l.line - 1] = start + this._replaceTerm + end;
        });
        return fileUri.withScheme(resource_1.MEMORY_TEXT).withQuery(lines.join('\n'));
    }
};
SearchInWorkspaceResultTreeWidget = __decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceResultTreeWidget);
exports.SearchInWorkspaceResultTreeWidget = SearchInWorkspaceResultTreeWidget;
//# sourceMappingURL=search-in-workspace-result-tree-widget.js.map