"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchInWorkspaceWidget = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const React = require("@theia/core/shared/react");
const browser_1 = require("@theia/core/lib/browser");
const search_in_workspace_widget_1 = require("@theia/search-in-workspace/lib/browser/search-in-workspace-widget");
/**
 * Workaround for https://github.com/eclipse-theia/theia/pull/9183.
 */
let SearchInWorkspaceWidget = class SearchInWorkspaceWidget extends search_in_workspace_widget_1.SearchInWorkspaceWidget {
    init() {
        super.init();
        this.title.iconClass = 'fa fa-arduino-search';
    }
    renderGlobField(kind) {
        const currentValue = this.searchInWorkspaceOptions[kind];
        const value = (currentValue && currentValue.join(', ')) || '';
        return (React.createElement("div", { className: "glob-field" },
            React.createElement("div", { className: "label" }, 'files to ' + kind),
            React.createElement("input", { className: "theia-input", type: "text", size: 1, defaultValue: value, id: kind + '-glob-field', onKeyUp: (e) => {
                    var _a;
                    if (e.target) {
                        const targetValue = e.target.value || '';
                        let shouldSearch = browser_1.Key.ENTER.keyCode ===
                            ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode);
                        const currentOptions = (this.searchInWorkspaceOptions[kind] || [])
                            .slice()
                            .map((s) => s.trim())
                            .sort();
                        const candidateOptions = this.splitOnComma(targetValue)
                            .map((s) => s.trim())
                            .sort();
                        const sameAs = (left, right) => {
                            if (left.length !== right.length) {
                                return false;
                            }
                            for (let i = 0; i < left.length; i++) {
                                if (left[i] !== right[i]) {
                                    return false;
                                }
                            }
                            return true;
                        };
                        if (!sameAs(currentOptions, candidateOptions)) {
                            this.searchInWorkspaceOptions[kind] =
                                this.splitOnComma(targetValue);
                            shouldSearch = true;
                        }
                        if (shouldSearch) {
                            this.resultTreeWidget.search(this.searchTerm, this.searchInWorkspaceOptions);
                        }
                    }
                }, onFocus: kind === 'include'
                    ? this.handleFocusIncludesInputBox
                    : this.handleFocusExcludesInputBox, onBlur: kind === 'include'
                    ? this.handleBlurIncludesInputBox
                    : this.handleBlurExcludesInputBox })));
    }
};
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SearchInWorkspaceWidget.prototype, "init", null);
SearchInWorkspaceWidget = __decorate([
    (0, inversify_1.injectable)()
], SearchInWorkspaceWidget);
exports.SearchInWorkspaceWidget = SearchInWorkspaceWidget;
//# sourceMappingURL=search-in-workspace-widget.js.map