"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceDeleteHandler = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const remote = require("@theia/core/electron-shared/@electron/remote");
const uri_1 = require("@theia/core/lib/common/uri");
const workspace_delete_handler_1 = require("@theia/workspace/lib/browser/workspace-delete-handler");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const common_1 = require("@theia/core/lib/common");
let WorkspaceDeleteHandler = class WorkspaceDeleteHandler extends workspace_delete_handler_1.WorkspaceDeleteHandler {
    async execute(uris) {
        const sketch = await this.sketchesServiceClient.currentSketch();
        if (!sketches_service_client_impl_1.CurrentSketch.isValid(sketch)) {
            return;
        }
        // Deleting the main sketch file.
        if (uris
            .map((uri) => uri.toString())
            .some((uri) => uri === sketch.mainFileUri)) {
            const { response } = await remote.dialog.showMessageBox({
                title: common_1.nls.localize('vscode/fileActions/delete', 'Delete'),
                type: 'question',
                buttons: [
                    common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                    common_1.nls.localize('vscode/issueMainService/ok', 'OK'),
                ],
                message: common_1.nls.localize('theia/workspace/deleteCurrentSketch', 'Do you want to delete the current sketch?'),
            });
            if (response === 1) {
                // OK
                await Promise.all([
                    ...sketch.additionalFileUris,
                    ...sketch.otherSketchFileUris,
                    sketch.mainFileUri,
                ].map((uri) => this.closeWithoutSaving(new uri_1.default(uri))));
                await this.fileService.delete(new uri_1.default(sketch.uri));
                window.close();
            }
            return;
        }
        return super.execute(uris);
    }
};
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], WorkspaceDeleteHandler.prototype, "sketchesServiceClient", void 0);
WorkspaceDeleteHandler = __decorate([
    (0, inversify_1.injectable)()
], WorkspaceDeleteHandler);
exports.WorkspaceDeleteHandler = WorkspaceDeleteHandler;
//# sourceMappingURL=workspace-delete-handler.js.map