"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceService = void 0;
const remote = require("@theia/core/electron-shared/@electron/remote");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const browser_1 = require("@theia/editor/lib/browser");
const label_provider_1 = require("@theia/core/lib/browser/label-provider");
const message_service_1 = require("@theia/core/lib/common/message-service");
const application_protocol_1 = require("@theia/core/lib/common/application-protocol");
const window_1 = require("@theia/core/lib/common/window");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const config_service_1 = require("../../../common/protocol/config-service");
const sketches_service_1 = require("../../../common/protocol/sketches-service");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const boards_config_1 = require("../../boards/boards-config");
const startup_task_1 = require("../../widgets/sketchbook/startup-task");
const window_2 = require("../../utils/window");
let WorkspaceService = class WorkspaceService extends workspace_service_1.WorkspaceService {
    async onStart(application) {
        const info = await this.applicationServer.getApplicationInfo();
        this.version = info === null || info === void 0 ? void 0 : info.version;
        application.shell.onDidChangeCurrentWidget(this.onCurrentWidgetChange.bind(this));
        const newValue = application.shell.currentWidget
            ? application.shell.currentWidget
            : null;
        this.onCurrentWidgetChange({ newValue, oldValue: null });
    }
    async toFileStat(uri) {
        const stat = await super.toFileStat(uri);
        if (!stat) {
            const newSketchUri = await this.sketchService.createNewSketch();
            return this.toFileStat(newSketchUri.uri);
        }
        return stat;
    }
    // Was copied from the Theia implementation.
    // Unlike the default behavior, IDE2 does not check the existence of the workspace before open.
    async doGetDefaultWorkspaceUri() {
        // If an empty window is explicitly requested do not restore a previous workspace.
        // Note: `window.location.hash` includes leading "#" if non-empty.
        if (window.location.hash === `#${window_1.DEFAULT_WINDOW_HASH}`) {
            window.location.hash = '';
            return undefined;
        }
        // Prefer the workspace path specified as the URL fragment, if present.
        if (window.location.hash.length > 1) {
            // Remove the leading # and decode the URI.
            const wpPath = decodeURI(window.location.hash.substring(1));
            const workspaceUri = new uri_1.default().withPath(wpPath).withScheme('file');
            // ### Customization! Here, we do no check if the workspace exists.
            // ### The error or missing sketch handling is done in the customized `toFileStat`.
            return workspaceUri.toString();
        }
        else {
            // Else, ask the server for its suggested workspace (usually the one
            // specified on the CLI, or the most recent).
            // ### Customization! the default workspace server will create a new sketch and will return with its URI if no recent workspaces are available.
            return this.server.getMostRecentlyUsedWorkspace();
        }
    }
    /**
     * Copied from Theia as-is to be able to pass the original `options` down.
     */
    async doOpen(uri, options) {
        const stat = await this.toFileStat(uri);
        if (stat) {
            if (!stat.isDirectory && !this.isWorkspaceFile(stat)) {
                const message = `Not a valid workspace: ${uri.path.toString()}`;
                this.messageService.error(message);
                throw new Error(message);
            }
            // The same window has to be preserved too (instead of opening a new one), if the workspace root is not yet available and we are setting it for the first time.
            // Option passed as parameter has the highest priority (for api developers), then the preference, then the default.
            await this.roots;
            const { preserveWindow } = Object.assign({ preserveWindow: this.preferences['workspace.preserveWindow'] || !this.opened }, options);
            await this.server.setMostRecentlyUsedWorkspace(uri.toString());
            if (preserveWindow) {
                this._workspace = stat;
            }
            this.openWindow(stat, Object.assign(options !== null && options !== void 0 ? options : {}, { preserveWindow })); // Unlike Theia, IDE2 passes the whole `input` downstream and not only { preserveWindow }
            return;
        }
        throw new Error('Invalid workspace root URI. Expected an existing directory or workspace file.');
    }
    /**
     * Copied from Theia. Can pass the `options` further down the chain.
     */
    openWindow(uri, options) {
        const workspacePath = uri.resource.path.toString();
        if (this.shouldPreserveWindow(options)) {
            this.reloadWindow(options); // Unlike Theia, IDE2 passes the `input` downstream.
        }
        else {
            try {
                this.openNewWindow(workspacePath, options); // Unlike Theia, IDE2 passes the `input` downstream.
            }
            catch (error) {
                // Fall back to reloading the current window in case the browser has blocked the new window
                this._workspace = uri;
                this.logger.error(error.toString()).then(() => this.reloadWindow());
            }
        }
    }
    reloadWindow(options) {
        if (startup_task_1.StartupTasks.WorkspaceInput.is(options)) {
            (0, window_2.setURL)(startup_task_1.StartupTask.append(options.tasks, new URL(window.location.href)));
        }
        super.reloadWindow();
    }
    openNewWindow(workspacePath, options) {
        const { boardsConfig } = this.boardsServiceProvider;
        let url = boards_config_1.BoardsConfig.Config.setConfig(boardsConfig, new URL(window.location.href)); // Set the current boards config for the new browser window.
        url.hash = workspacePath;
        if (startup_task_1.StartupTasks.WorkspaceInput.is(options)) {
            url = startup_task_1.StartupTask.append(options.tasks, url);
        }
        this.windowService.openNewWindow(url.toString());
    }
    onCurrentWidgetChange({ newValue, }) {
        if (newValue instanceof browser_1.EditorWidget) {
            const { uri } = newValue.editor;
            const currentWindow = remote.getCurrentWindow();
            currentWindow.setRepresentedFilename(uri.path.toString());
            if (sketches_service_1.Sketch.isSketchFile(uri.toString())) {
                this.updateTitle();
            }
            else {
                const title = this.workspaceTitle;
                const fileName = this.labelProvider.getName(uri);
                document.title = this.formatTitle(title ? `${title} - ${fileName}` : fileName);
            }
        }
        else {
            this.updateTitle();
        }
    }
    formatTitle(title) {
        const version = this.version ? ` ${this.version}` : '';
        const name = `${this.applicationName} ${version}`;
        return title ? `${title} | ${name}` : name;
    }
    get workspaceTitle() {
        if (this.workspace) {
            return this.labelProvider.getName(this.workspace.resource);
        }
    }
};
__decorate([
    (0, inversify_1.inject)(sketches_service_1.SketchesService),
    __metadata("design:type", Object)
], WorkspaceService.prototype, "sketchService", void 0);
__decorate([
    (0, inversify_1.inject)(config_service_1.ConfigService),
    __metadata("design:type", Object)
], WorkspaceService.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], WorkspaceService.prototype, "labelProvider", void 0);
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], WorkspaceService.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(application_protocol_1.ApplicationServer),
    __metadata("design:type", Object)
], WorkspaceService.prototype, "applicationServer", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], WorkspaceService.prototype, "appStateService", void 0);
__decorate([
    (0, inversify_1.inject)(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], WorkspaceService.prototype, "boardsServiceProvider", void 0);
WorkspaceService = __decorate([
    (0, inversify_1.injectable)()
], WorkspaceService);
exports.WorkspaceService = WorkspaceService;
//# sourceMappingURL=workspace-service.js.map