"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoSelect = void 0;
const React = require("@theia/core/shared/react");
const react_select_1 = require("react-select");
class ArduinoSelect extends react_select_1.default {
    constructor(props) {
        super(props);
    }
    render() {
        const controlHeight = 27; // from `monitor.css` -> `.serial-monitor-container .head` (`height: 27px;`)
        const styles = {
            control: (styles) => (Object.assign(Object.assign({}, styles), { minWidth: 120, color: 'var(--theia-foreground)' })),
            dropdownIndicator: (styles) => (Object.assign(Object.assign({}, styles), { padding: 0 })),
            indicatorSeparator: () => ({
                display: 'none',
            }),
            indicatorsContainer: () => ({
                padding: '0px 5px',
            }),
            menu: (styles) => (Object.assign(Object.assign({}, styles), { marginTop: 0 })),
        };
        const theme = (theme) => (Object.assign(Object.assign({}, theme), { borderRadius: 0, spacing: {
                controlHeight,
                baseUnit: 2,
                menuGutter: 4,
            }, colors: Object.assign(Object.assign({}, theme.colors), { 
                // `primary50`??? it's crazy but apparently, without this, we would get a light-blueish
                // color when selecting an option in the select by clicking and then not releasing the button.
                // https://react-select.com/styles#overriding-the-theme
                primary50: 'var(--theia-list-activeSelectionBackground)' }) }));
        const DropdownIndicator = () => React.createElement("span", { className: "fa fa-caret-down caret" });
        return (React.createElement(react_select_1.default, Object.assign({}, this.props, { className: "theia-select", components: { DropdownIndicator }, theme: theme, styles: styles, classNamePrefix: "arduino-select", isSearchable: false })));
    }
}
exports.ArduinoSelect = ArduinoSelect;
//# sourceMappingURL=arduino-select.js.map