"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudSketchbookTreeWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const cloud_sketchbook_tree_model_1 = require("./cloud-sketchbook-tree-model");
const authentication_client_service_1 = require("../../auth/authentication-client-service");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const cloud_sketchbook_tree_1 = require("./cloud-sketchbook-tree");
const cloud_user_commands_1 = require("../../auth/cloud-user-commands");
const browser_1 = require("@theia/core/lib/browser");
const electron_1 = require("electron");
const sketchbook_tree_widget_1 = require("../sketchbook/sketchbook-tree-widget");
const common_1 = require("@theia/core/lib/common");
const LEARN_MORE_URL = 'https://docs.arduino.cc/software/ide-v2/tutorials/ide-v2-cloud-sketch-sync';
let CloudSketchbookTreeWidget = class CloudSketchbookTreeWidget extends sketchbook_tree_widget_1.SketchbookTreeWidget {
    async init() {
        await super.init();
        this.addClass('tree-container'); // Adds `height: 100%` to the tree. Otherwise you cannot see it.
    }
    renderTree(model) {
        if (this.shouldShowWelcomeView())
            return this.renderViewWelcome();
        if (this.shouldShowEmptyView())
            return this.renderEmptyView();
        return super.renderTree(model);
    }
    renderEmptyView() {
        return (React.createElement("div", { className: "cloud-sketchbook-welcome center" },
            React.createElement("div", { className: "center item" },
                React.createElement("div", null,
                    React.createElement("p", null,
                        React.createElement("b", null, common_1.nls.localize('arduino/cloud/emptySketchbook', 'Your Sketchbook is empty'))),
                    React.createElement("p", null, common_1.nls.localize('arduino/cloud/visitArduinoCloud', 'Visit Arduino Cloud to create Cloud Sketches.')))),
            React.createElement("button", { className: "theia-button", onClick: () => electron_1.shell.openExternal('https://create.arduino.cc/editor') }, common_1.nls.localize('cloud/GoToCloud', 'GO TO CLOUD')),
            React.createElement("div", { className: "center item" })));
    }
    shouldShowWelcomeView() {
        if (!this.model || this.model instanceof cloud_sketchbook_tree_model_1.CloudSketchbookTreeModel) {
            return !this.authenticationService.session;
        }
        return super.shouldShowWelcomeView();
    }
    shouldShowEmptyView() {
        const node = this.cloudSketchbookTree.root;
        return browser_1.CompositeTreeNode.is(node) && node.children.length === 0;
    }
    createNodeClassNames(node, props) {
        const classNames = super.createNodeClassNames(node, props);
        if (node &&
            node.hasOwnProperty('underlying') &&
            this.currentSketchUri === node.underlying.toString()) {
            classNames.push('active-sketch');
        }
        return classNames;
    }
    renderInlineCommands(node) {
        if (cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(node) && node.commands) {
            return Array.from(new Set(node.commands)).map((command) => {
                var _a, _b;
                return this.renderInlineCommand(command.id, node, {
                    username: (_b = (_a = this.authenticationService.session) === null || _a === void 0 ? void 0 : _a.account) === null || _b === void 0 ? void 0 : _b.label,
                });
            });
        }
        return undefined;
    }
    renderViewWelcome() {
        return (React.createElement("div", { className: "cloud-sketchbook-welcome center" },
            React.createElement("div", { className: "center item" },
                React.createElement("div", null,
                    React.createElement("p", { className: "sign-in-title" }, common_1.nls.localize('arduino/cloud/signInToCloud', 'Sign in to Arduino Cloud')),
                    React.createElement("p", { className: "sign-in-desc" }, common_1.nls.localize('arduino/cloud/syncEditSketches', 'Sync and edit your Arduino Cloud Sketches')))),
            React.createElement("button", { className: "theia-button sign-in-cta", onClick: () => this.commandRegistry.executeCommand(cloud_user_commands_1.CloudUserCommands.LOGIN.id) }, common_1.nls.localize('arduino/cloud/signIn', 'SIGN IN')),
            React.createElement("div", { className: "center item" },
                React.createElement("div", { className: "link sign-in-learnmore", onClick: () => this.windowService.openNewWindow(LEARN_MORE_URL, {
                        external: true,
                    }) }, common_1.nls.localize('arduino/cloud/learnMore', 'Learn more')))));
    }
    handleDblClickEvent(node, event) {
        event.persist();
        if (cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchTreeNode.is(node) &&
            cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchTreeNode.isSynced(node)) {
            super.handleDblClickEvent(node, event);
        }
    }
};
__decorate([
    (0, inversify_1.inject)(authentication_client_service_1.AuthenticationClientService),
    __metadata("design:type", authentication_client_service_1.AuthenticationClientService)
], CloudSketchbookTreeWidget.prototype, "authenticationService", void 0);
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], CloudSketchbookTreeWidget.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(cloud_sketchbook_tree_1.CloudSketchbookTree),
    __metadata("design:type", cloud_sketchbook_tree_1.CloudSketchbookTree)
], CloudSketchbookTreeWidget.prototype, "cloudSketchbookTree", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], CloudSketchbookTreeWidget.prototype, "init", null);
CloudSketchbookTreeWidget = __decorate([
    (0, inversify_1.injectable)()
], CloudSketchbookTreeWidget);
exports.CloudSketchbookTreeWidget = CloudSketchbookTreeWidget;
//# sourceMappingURL=cloud-sketchbook-tree-widget.js.map