"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
var CloudSketchbookTree_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudSketchbookTree = void 0;
const cloud_sketch_cache_1 = require("./cloud-sketch-cache");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const file_tree_1 = require("@theia/filesystem/lib/browser/file-tree");
const tree_decorator_1 = require("@theia/core/lib/browser/tree/tree-decorator");
const file_tree_2 = require("@theia/filesystem/lib/browser/file-tree/file-tree");
const preference_service_1 = require("@theia/core/lib/browser/preferences/preference-service");
const message_service_1 = require("@theia/core/lib/common/message-service");
const create_api_1 = require("../../create/create-api");
const create_uri_1 = require("../../create/create-uri");
const local_cache_fs_provider_1 = require("../../local-cache/local-cache-fs-provider");
const cloud_sketchbook_contributions_1 = require("./cloud-sketchbook-contributions");
const do_not_ask_again_dialog_1 = require("../../dialogs/do-not-ask-again-dialog");
const sketchbook_tree_1 = require("../sketchbook/sketchbook-tree");
const utils_1 = require("../../../common/utils");
const arduino_preferences_1 = require("../../arduino-preferences");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const navigator_tree_1 = require("@theia/navigator/lib/browser/navigator-tree");
const create_paths_1 = require("../../create/create-paths");
const typings_1 = require("../../create/typings");
const common_1 = require("@theia/core/lib/common");
const MESSAGE_TIMEOUT = 5 * 1000;
const deepmerge = require('deepmerge').default;
let CloudSketchbookTree = CloudSketchbookTree_1 = class CloudSketchbookTree extends sketchbook_tree_1.SketchbookTree {
    constructor() {
        super(...arguments);
        this.notInSyncDecoration = {
            fontData: {
                color: 'var(--theia-activityBar-inactiveForeground)',
            },
        };
        this.inSyncDecoration = {
            fontData: {},
        };
    }
    async pushPublicWarn(node) {
        const warn = node.isPublic && this.arduinoPreferences['arduino.cloud.pushpublic.warn'];
        if (warn) {
            const ok = await new do_not_ask_again_dialog_1.DoNotAskAgainConfirmDialog({
                ok: common_1.nls.localize('arduino/cloud/continue', 'Continue'),
                cancel: common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                title: common_1.nls.localize('arduino/cloud/pushSketch', 'Push Sketch'),
                msg: common_1.nls.localize('arduino/cloud/pushSketchMsg', 'This is a Public Sketch. Before pushing, make sure any sensitive information is defined in arduino_secrets.h files. You can make a Sketch private from the Share panel.'),
                maxWidth: 400,
                onAccept: () => this.preferenceService.set('arduino.cloud.pushpublic.warn', false, preference_service_1.PreferenceScope.User),
            }).open();
            if (!ok) {
                return false;
            }
            return true;
        }
        else {
            return true;
        }
    }
    async pull(arg) {
        const { 
        // model,
        node, } = arg;
        const warn = CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(node) &&
            this.arduinoPreferences['arduino.cloud.pull.warn'];
        if (warn) {
            const ok = await new do_not_ask_again_dialog_1.DoNotAskAgainConfirmDialog({
                ok: common_1.nls.localize('arduino/cloud/pull', 'Pull'),
                cancel: common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                title: common_1.nls.localize('arduino/cloud/pullSketch', 'Pull Sketch'),
                msg: common_1.nls.localize('arduino/cloud/pullSketchMsg', 'Pulling this Sketch from the Cloud will overwrite its local version. Are you sure you want to continue?'),
                maxWidth: 400,
                onAccept: () => this.preferenceService.set('arduino.cloud.pull.warn', false, preference_service_1.PreferenceScope.User),
            }).open();
            if (!ok) {
                return;
            }
        }
        this.runWithState(node, 'pulling', async (node) => {
            const commandsCopy = node.commands;
            node.commands = [];
            const localUri = await this.fileService.toUnderlyingResource(local_cache_fs_provider_1.LocalCacheUri.root.resolve(node.remoteUri.path));
            await this.sync(node.remoteUri, localUri);
            this.sketchCache.purgeByPath(node.remoteUri.path.toString());
            node.commands = commandsCopy;
            this.messageService.info(common_1.nls.localize('arduino/cloud/donePulling', 'Done pulling ‘{0}’.', node.fileStat.name), {
                timeout: MESSAGE_TIMEOUT,
            });
        });
    }
    async push(node) {
        if (!CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(node)) {
            throw new Error(common_1.nls.localize('arduino/cloud/notYetPulled', 'Cannot push to Cloud. It is not yet pulled.'));
        }
        const pushPublic = await this.pushPublicWarn(node);
        if (!pushPublic) {
            return;
        }
        const warn = this.arduinoPreferences['arduino.cloud.push.warn'];
        if (warn) {
            const ok = await new do_not_ask_again_dialog_1.DoNotAskAgainConfirmDialog({
                ok: common_1.nls.localize('arduino/cloud/push', 'Push'),
                cancel: common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'),
                title: common_1.nls.localize('arduino/cloud/pushSketch', 'Push Sketch'),
                msg: 'Pushing this Sketch will overwrite its Cloud version. Are you sure you want to continue?',
                maxWidth: 400,
                onAccept: () => this.preferenceService.set('arduino.cloud.push.warn', false, preference_service_1.PreferenceScope.User),
            }).open();
            if (!ok) {
                return;
            }
        }
        this.runWithState(node, 'pushing', async (node) => {
            if (!CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(node)) {
                throw new Error(common_1.nls.localize('arduino/cloud/pullFirst', 'You have to pull first to be able to push to the Cloud.'));
            }
            const commandsCopy = node.commands;
            node.commands = [];
            const localUri = await this.fileService.toUnderlyingResource(local_cache_fs_provider_1.LocalCacheUri.root.resolve(node.remoteUri.path));
            await this.sync(localUri, node.remoteUri);
            this.sketchCache.purgeByPath(node.remoteUri.path.toString());
            node.commands = commandsCopy;
            this.messageService.info(common_1.nls.localize('arduino/cloud/donePushing', 'Done pushing ‘{0}’.', node.fileStat.name), {
                timeout: MESSAGE_TIMEOUT,
            });
        });
    }
    async recursiveURIs(uri) {
        var e_1, _a;
        // remote resources can be fetched one-shot via api
        if (create_uri_1.CreateUri.is(uri)) {
            const resources = await this.createApi.readDirectory(uri.path.toString(), { recursive: true, skipSketchCache: true });
            return resources.map((resource) => create_uri_1.CreateUri.toUri((0, create_paths_1.splitSketchPath)(resource.path)[1]));
        }
        const fileStat = await this.fileService.resolve(uri, {
            resolveMetadata: false,
        });
        if (!fileStat.children || !fileStat.isDirectory) {
            return [fileStat.resource];
        }
        let childrenUris = [];
        try {
            for (var _b = __asyncValues(fileStat.children), _c; _c = await _b.next(), !_c.done;) {
                const child = _c.value;
                childrenUris = [
                    ...childrenUris,
                    ...(await this.recursiveURIs(child.resource)),
                ];
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) await _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return [fileStat.resource, ...childrenUris];
    }
    URIsToMap(uris, basepath) {
        return uris.reduce((prev, curr) => {
            const path = curr.toString().split(basepath);
            if (path.length !== 2 || path[1].length === 0) {
                return prev;
            }
            // do not map "do_not_sync" files/directoris and their descendants
            const segments = path[1].split(create_paths_1.posix.sep) || [];
            if (segments.some((segment) => typings_1.Create.do_not_sync_files.includes(segment))) {
                return prev;
            }
            // skip when the filename is a hidden file (starts with `.`)
            if (segments[segments.length - 1].indexOf('.') === 0) {
                return prev;
            }
            return Object.assign(Object.assign({}, prev), { [path[1]]: curr });
        }, {});
    }
    async getUrisMap(uri) {
        const basepath = uri.toString();
        const exists = await this.fileService.exists(uri);
        const uris = (exists && this.URIsToMap(await this.recursiveURIs(uri), basepath)) || {};
        return uris;
    }
    async treeDiff(source, dest) {
        const [sourceURIs, destURIs] = await Promise.all([
            this.getUrisMap(source),
            this.getUrisMap(dest),
        ]);
        const destBase = dest.toString();
        const filesToWrite = [];
        Object.keys(sourceURIs).forEach((path) => {
            const destUri = destURIs[path] || new uri_1.default(destBase + path);
            filesToWrite.push({ source: sourceURIs[path], dest: destUri });
            delete destURIs[path];
        });
        const filesToDelete = Object.values(destURIs);
        return { filesToWrite, filesToDelete };
    }
    async refresh(node) {
        if (node) {
            const showAllFiles = this.arduinoPreferences['arduino.sketchbook.showAllFiles'];
            await this.decorateNode(node, showAllFiles);
        }
        return super.refresh(node);
    }
    async runWithState(node, state, task) {
        var _a, _b, _c, _d;
        const decoration = {
            data: `${(0, utils_1.firstToUpperCase)(state)}...`,
            fontData: {
                color: 'var(--theia-list-highlightForeground)',
            },
        };
        try {
            node.state = state;
            this.mergeDecoration(node, { tailDecorations: [decoration] });
            await this.refresh(node);
            const result = await task(node);
            return result;
        }
        finally {
            delete node.state;
            // TODO: find a better way to attach and detach decorators. Do we need a proper `TreeDecorator` instead?
            const index = (_b = (_a = node.decorationData) === null || _a === void 0 ? void 0 : _a.tailDecorations) === null || _b === void 0 ? void 0 : _b.findIndex((candidate) => JSON.stringify(decoration) === JSON.stringify(candidate));
            if (typeof index === 'number' && index !== -1) {
                (_d = (_c = node.decorationData) === null || _c === void 0 ? void 0 : _c.tailDecorations) === null || _d === void 0 ? void 0 : _d.splice(index, 1);
            }
            await this.refresh(node);
        }
    }
    async sync(source, dest) {
        const { filesToWrite, filesToDelete } = await this.treeDiff(source, dest);
        await Promise.all(filesToWrite.map(async ({ source, dest }) => {
            if ((await this.fileService.resolve(source)).isFile) {
                const content = await this.fileService.read(source);
                return this.fileService.write(dest, content.value);
            }
            return this.fileService.createFolder(dest);
        }));
        await Promise.all(filesToDelete.map((file) => this.fileService.delete(file, { recursive: true })));
    }
    async resolveChildren(parent) {
        return (await super.resolveChildren(parent)).sort((a, b) => {
            if (navigator_tree_1.WorkspaceNode.is(parent) &&
                file_tree_1.FileStatNode.is(a) &&
                file_tree_1.FileStatNode.is(b)) {
                const syncNodeA = CloudSketchbookTree_1.CloudSketchTreeNode.is(a) &&
                    CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(a);
                const syncNodeB = CloudSketchbookTree_1.CloudSketchTreeNode.is(b) &&
                    CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(b);
                const syncComparison = Number(syncNodeB) - Number(syncNodeA);
                // same sync status, compare on modified time
                if (syncComparison === 0) {
                    return (b.fileStat.mtime || 0) - (a.fileStat.mtime || 0);
                }
                return syncComparison;
            }
            return 0;
        });
    }
    /**
     * Retrieve fileStats for the given node, merging the local and remote children
     * Local children take precedence over remote ones
     * @param node
     * @returns
     */
    async resolveFileStat(node) {
        if (CloudSketchbookTree_1.CloudSketchTreeNode.is(node) &&
            create_uri_1.CreateUri.is(node.remoteUri)) {
            let remoteFileStat;
            const cacheHit = this.sketchCache.getItem(node.remoteUri.path.toString());
            if (cacheHit) {
                remoteFileStat = cacheHit;
            }
            else {
                // not found, fetch and add it for future calls
                remoteFileStat = await this.fileService.resolve(node.remoteUri);
                if (remoteFileStat) {
                    this.sketchCache.addItem(remoteFileStat);
                }
            }
            const children = [...((remoteFileStat === null || remoteFileStat === void 0 ? void 0 : remoteFileStat.children) || [])];
            const childrenLocalPaths = children.map((child) => {
                return (this.localCacheFsProvider.currentUserUri.path.toString() +
                    child.resource.path.toString());
            });
            // if the node is in sync, also get local-only children
            if (CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(node)) {
                const localFileStat = await this.fileService.resolve(node.uri);
                // merge the two children
                for (const child of localFileStat.children || []) {
                    if (!childrenLocalPaths.includes(child.resource.path.toString())) {
                        children.push(child);
                    }
                }
            }
            // add a remote uri for the children. it's used as ID for the nodes
            const childrenWithRemoteUri = await Promise.all(children.map(async (childFs) => {
                let remoteUri = childFs.resource;
                if (!create_uri_1.CreateUri.is(childFs.resource)) {
                    let refUri = node.fileStat.resource;
                    if (node.fileStat.hasOwnProperty('remoteUri')) {
                        refUri = node.fileStat.remoteUri;
                    }
                    remoteUri = refUri.resolve(childFs.name);
                }
                return Object.assign(Object.assign({}, childFs), { remoteUri });
            }));
            const fileStat = Object.assign(Object.assign({}, remoteFileStat), { children: childrenWithRemoteUri });
            node.fileStat = fileStat;
            return fileStat;
        }
        else {
            // it's a local-only file
            return super.resolveFileStat(node);
        }
    }
    toNode(fileStat, parent) {
        const uri = fileStat.resource;
        let idUri;
        if (fileStat.remoteUri) {
            idUri = fileStat.remoteUri;
        }
        const id = this.toNodeId(idUri || uri, parent);
        const node = this.getNode(id);
        if (fileStat.isDirectory) {
            if (file_tree_2.DirNode.is(node)) {
                node.uri = uri;
                node.fileStat = fileStat;
                return node;
            }
            return {
                id,
                uri,
                fileStat,
                parent,
                expanded: false,
                selected: false,
                children: [],
            };
        }
        if (file_tree_2.FileNode.is(node)) {
            node.fileStat = fileStat;
            node.uri = uri;
            return node;
        }
        return {
            id,
            uri,
            fileStat,
            parent,
            selected: false,
        };
    }
    /**
     * Add commands available to the given node.
     * In the case the node is a sketch, it also adds sketchId and isPublic flags
     * @param node
     * @returns
     */
    async augmentSketchNode(node) {
        const sketch = this.sketchCache.getSketch(node.fileStat.resource.path.toString());
        const commands = [cloud_sketchbook_contributions_1.CloudSketchbookCommands.PULL_SKETCH];
        if (CloudSketchbookTree_1.CloudSketchTreeNode.is(node) &&
            CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(node)) {
            commands.push(cloud_sketchbook_contributions_1.CloudSketchbookCommands.PUSH_SKETCH);
        }
        commands.push(cloud_sketchbook_contributions_1.CloudSketchbookCommands.OPEN_SKETCHBOOKSYNC_CONTEXT_MENU);
        Object.assign(node, Object.assign(Object.assign(Object.assign({ type: 'sketch' }, (sketch && {
            isPublic: sketch.is_public,
        })), (sketch && {
            sketchId: sketch.id,
        })), { commands }));
    }
    async nodeLocalUri(node) {
        if (file_tree_1.FileStatNode.is(node) && create_uri_1.CreateUri.is(node.uri)) {
            Object.assign(node, { remoteUri: node.uri });
            const localUri = await this.localUri(node);
            if (localUri) {
                // if the node has a local uri, use it
                const underlying = await this.fileService.toUnderlyingResource(localUri);
                node.uri = underlying;
            }
        }
        // add style decoration for not-in-sync files
        if (CloudSketchbookTree_1.CloudSketchTreeNode.is(node) &&
            !CloudSketchbookTree_1.CloudSketchTreeNode.isSynced(node)) {
            this.mergeDecoration(node, this.notInSyncDecoration);
        }
        else {
            this.removeDecoration(node, this.notInSyncDecoration);
        }
        return node;
    }
    async decorateNode(node, showAllFiles) {
        node = await this.nodeLocalUri(node);
        node = await super.decorateNode(node, showAllFiles);
        return node;
    }
    async isSketchNode(node) {
        if (file_tree_2.DirNode.is(node)) {
            const sketch = this.sketchCache.getSketch(node.fileStat.resource.path.toString());
            return !!sketch;
        }
        return false;
    }
    mergeDecoration(node, decorationData) {
        Object.assign(node, {
            decorationData: deepmerge(tree_decorator_1.DecoratedTreeNode.is(node) ? node.decorationData : {}, decorationData),
        });
    }
    removeDecoration(node, decorationData) {
        if (tree_decorator_1.DecoratedTreeNode.is(node)) {
            for (const property of Object.keys(decorationData)) {
                if (node.decorationData.hasOwnProperty(property)) {
                    delete node.decorationData[property];
                }
            }
        }
    }
    async localUri(node) {
        const localUri = local_cache_fs_provider_1.LocalCacheUri.root.resolve(node.uri.path);
        const exists = await this.fileService.exists(localUri);
        if (exists) {
            return localUri;
        }
        return undefined;
    }
};
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], CloudSketchbookTree.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(local_cache_fs_provider_1.LocalCacheFsProvider),
    __metadata("design:type", local_cache_fs_provider_1.LocalCacheFsProvider)
], CloudSketchbookTree.prototype, "localCacheFsProvider", void 0);
__decorate([
    (0, inversify_1.inject)(cloud_sketch_cache_1.SketchCache),
    __metadata("design:type", cloud_sketch_cache_1.SketchCache)
], CloudSketchbookTree.prototype, "sketchCache", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], CloudSketchbookTree.prototype, "arduinoPreferences", void 0);
__decorate([
    (0, inversify_1.inject)(preference_service_1.PreferenceService),
    __metadata("design:type", Object)
], CloudSketchbookTree.prototype, "preferenceService", void 0);
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], CloudSketchbookTree.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], CloudSketchbookTree.prototype, "sketchServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(create_api_1.CreateApi),
    __metadata("design:type", create_api_1.CreateApi)
], CloudSketchbookTree.prototype, "createApi", void 0);
CloudSketchbookTree = CloudSketchbookTree_1 = __decorate([
    (0, inversify_1.injectable)()
], CloudSketchbookTree);
exports.CloudSketchbookTree = CloudSketchbookTree;
(function (CloudSketchbookTree) {
    let CloudSketchTreeNode;
    (function (CloudSketchTreeNode) {
        function is(node) {
            return !!node && typeof node.hasOwnProperty('remoteUri') !== 'undefined';
        }
        CloudSketchTreeNode.is = is;
        function isSynced(node) {
            return node.remoteUri !== node.uri;
        }
        CloudSketchTreeNode.isSynced = isSynced;
    })(CloudSketchTreeNode = CloudSketchbookTree.CloudSketchTreeNode || (CloudSketchbookTree.CloudSketchTreeNode = {}));
    let CloudSketchDirNode;
    (function (CloudSketchDirNode) {
        function is(node) {
            return sketchbook_tree_1.SketchbookTree.SketchDirNode.is(node);
        }
        CloudSketchDirNode.is = is;
    })(CloudSketchDirNode = CloudSketchbookTree.CloudSketchDirNode || (CloudSketchbookTree.CloudSketchDirNode = {}));
})(CloudSketchbookTree = exports.CloudSketchbookTree || (exports.CloudSketchbookTree = {}));
exports.CloudSketchbookTree = CloudSketchbookTree;
//# sourceMappingURL=cloud-sketchbook-tree.js.map