"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentListItem = void 0;
const React = require("@theia/core/shared/react");
class ComponentListItem extends React.Component {
    constructor(props) {
        super(props);
        if (props.item.installable) {
            const version = props.item.availableVersions.filter((version) => version !== props.item.installedVersion)[0];
            this.state = {
                selectedVersion: version,
                focus: false,
            };
        }
    }
    componentDidUpdate(prevProps, prevState) {
        if (this.state.focus !== prevState.focus) {
            this.props.onFocusDidChange();
        }
    }
    render() {
        const { item, itemRenderer } = this.props;
        return (React.createElement("div", { onMouseEnter: () => this.setState({ focus: true }), onMouseLeave: () => this.setState({ focus: false }) }, itemRenderer.renderItem(Object.assign(this.state, { item }), this.install.bind(this), this.uninstall.bind(this), this.onVersionChange.bind(this))));
    }
    async install(item) {
        const toInstall = this.state.selectedVersion;
        const version = this.props.item.availableVersions.filter((version) => version !== this.state.selectedVersion)[0];
        this.setState({
            selectedVersion: version,
        });
        try {
            await this.props.install(item, toInstall);
        }
        catch (_a) {
            this.setState({
                selectedVersion: toInstall,
            });
        }
    }
    async uninstall(item) {
        await this.props.uninstall(item);
    }
    onVersionChange(version) {
        this.setState({ selectedVersion: version });
    }
}
exports.ComponentListItem = ComponentListItem;
//# sourceMappingURL=component-list-item.js.map