"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentList = void 0;
require("react-virtualized/styles.css");
const React = require("@theia/core/shared/react");
const AutoSizer_1 = require("react-virtualized/dist/commonjs/AutoSizer");
const CellMeasurer_1 = require("react-virtualized/dist/commonjs/CellMeasurer");
const List_1 = require("react-virtualized/dist/commonjs/List");
const component_list_item_1 = require("./component-list-item");
function sameAs(left, right, ...compareProps) {
    if (left === right) {
        return true;
    }
    const leftLength = left.length;
    if (leftLength !== right.length) {
        return false;
    }
    for (let i = 0; i < leftLength; i++) {
        for (const prop of compareProps) {
            const leftValue = left[i][prop];
            const rightValue = right[i][prop];
            if (leftValue !== rightValue) {
                return false;
            }
        }
    }
    return true;
}
class ComponentList extends React.Component {
    constructor(props) {
        super(props);
        this.setListRef = (ref) => {
            this.list = ref || undefined;
        };
        this.createItem = ({ index, parent, key, style, }) => {
            const item = this.props.items[index];
            return (React.createElement(CellMeasurer_1.CellMeasurer, { cache: this.cache, columnIndex: 0, key: key, rowIndex: index, parent: parent }, ({ measure, registerChild }) => (
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            React.createElement("div", { ref: registerChild, style: style },
                React.createElement(component_list_item_1.ComponentListItem, { key: this.props.itemLabel(item), item: item, itemRenderer: this.props.itemRenderer, install: this.props.install, uninstall: this.props.uninstall, onFocusDidChange: () => measure() })))));
        };
        this.cache = new CellMeasurer_1.CellMeasurerCache({
            defaultHeight: 140,
            fixedWidth: true,
        });
    }
    render() {
        return (React.createElement(AutoSizer_1.default, null, ({ width, height }) => {
            if (this.mostRecentWidth && this.mostRecentWidth !== width) {
                this.resizeAllFlag = true;
                setTimeout(() => this.clearAll(), 0);
            }
            this.mostRecentWidth = width;
            return (React.createElement(List_1.default, { className: 'items-container', rowRenderer: this.createItem, height: height, width: width, rowCount: this.props.items.length, rowHeight: this.cache.rowHeight, deferredMeasurementCache: this.cache, ref: this.setListRef, estimatedRowSize: 140, 
                // If default value, then `react-virtualized` will optimize and list item will not receive a `:hover` event.
                // Hence, install and version `<select>` won't be visible even if the mouse cursor is over the `<div>`.
                // See https://github.com/bvaughn/react-virtualized/blob/005be24a608add0344284053dae7633be86053b2/source/Grid/Grid.js#L38-L42
                scrollingResetTimeInterval: 0 }));
        }));
    }
    componentDidUpdate(prevProps) {
        if (this.resizeAllFlag ||
            !sameAs(this.props.items, prevProps.items, 'name', 'installedVersion')) {
            this.clearAll(true);
        }
    }
    clearAll(scrollToTop = false) {
        this.resizeAllFlag = false;
        this.cache.clearAll();
        if (this.list) {
            this.list.recomputeRowHeights();
            if (scrollToTop) {
                this.list.scrollToPosition(0);
            }
        }
    }
}
exports.ComponentList = ComponentList;
//# sourceMappingURL=component-list.js.map