"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryFilterRenderer = exports.BoardsFilterRenderer = exports.FilterRenderer = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const React = require("@theia/core/shared/react");
const protocol_1 = require("../../../common/protocol");
let FilterRenderer = class FilterRenderer {
    render(options, handlePropChange) {
        const props = this.props();
        return (React.createElement("div", { className: "filter-bar" }, Object.entries(options)
            .filter(([prop]) => props.includes(prop))
            .map(([prop, value]) => (React.createElement("div", { key: prop, className: "filter" },
            React.createElement("div", { className: "filter-label" }, `${this.propertyLabel(prop)}:`),
            React.createElement("select", { className: "theia-select", value: value, onChange: (event) => 
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                handlePropChange(prop, event.target.value) }, this.options(prop).map((key) => (React.createElement("option", { key: key, value: key }, this.valueLabel(prop, key))))))))));
    }
};
FilterRenderer = __decorate([
    (0, inversify_1.injectable)()
], FilterRenderer);
exports.FilterRenderer = FilterRenderer;
let BoardsFilterRenderer = class BoardsFilterRenderer extends FilterRenderer {
    props() {
        return ['type'];
    }
    options(prop) {
        switch (prop) {
            case 'type':
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return protocol_1.BoardSearch.TypeLiterals;
            default:
                throw new Error(`Unexpected prop: ${prop}`);
        }
    }
    valueLabel(prop, key) {
        switch (prop) {
            case 'type':
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return protocol_1.BoardSearch.TypeLabels[key];
            default:
                throw new Error(`Unexpected key: ${prop}`);
        }
    }
    propertyLabel(prop) {
        switch (prop) {
            case 'type':
                return protocol_1.BoardSearch.PropertyLabels[prop];
            default:
                throw new Error(`Unexpected key: ${prop}`);
        }
    }
};
BoardsFilterRenderer = __decorate([
    (0, inversify_1.injectable)()
], BoardsFilterRenderer);
exports.BoardsFilterRenderer = BoardsFilterRenderer;
let LibraryFilterRenderer = class LibraryFilterRenderer extends FilterRenderer {
    props() {
        return ['type', 'topic'];
    }
    options(prop) {
        switch (prop) {
            case 'type':
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return protocol_1.LibrarySearch.TypeLiterals;
            case 'topic':
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return protocol_1.LibrarySearch.TopicLiterals;
            default:
                throw new Error(`Unexpected prop: ${prop}`);
        }
    }
    propertyLabel(prop) {
        switch (prop) {
            case 'type':
            case 'topic':
                return protocol_1.LibrarySearch.PropertyLabels[prop];
            default:
                throw new Error(`Unexpected key: ${prop}`);
        }
    }
    valueLabel(prop, key) {
        switch (prop) {
            case 'type':
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return protocol_1.LibrarySearch.TypeLabels[key];
            case 'topic':
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return protocol_1.LibrarySearch.TopicLabels[key];
            default:
                throw new Error(`Unexpected prop: ${prop}`);
        }
    }
};
LibraryFilterRenderer = __decorate([
    (0, inversify_1.injectable)()
], LibraryFilterRenderer);
exports.LibraryFilterRenderer = LibraryFilterRenderer;
//# sourceMappingURL=filter-renderer.js.map