"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListWidget = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const event_1 = require("@theia/core/lib/common/event");
const react_widget_1 = require("@theia/core/lib/browser/widgets/react-widget");
const command_1 = require("@theia/core/lib/common/command");
const message_service_1 = require("@theia/core/lib/common/message-service");
const protocol_1 = require("../../../common/protocol");
const filterable_list_container_1 = require("./filterable-list-container");
const notification_center_1 = require("../../notification-center");
let ListWidget = class ListWidget extends react_widget_1.ReactWidget {
    constructor(options) {
        super();
        this.options = options;
        this.searchOptionsChangeEmitter = new event_1.Emitter();
        /**
         * Instead of running an `update` from the `postConstruct` `init` method,
         * we use this variable to track first activate, then run.
         */
        this.firstActivate = true;
        this.onFocusResolved = (element) => {
            this.focusNode = element;
        };
        const { id, label, iconClass } = options;
        this.id = id;
        this.title.label = label;
        this.title.caption = label;
        this.title.iconClass = iconClass;
        this.title.closable = true;
        this.addClass('arduino-list-widget');
        this.node.tabIndex = 0; // To be able to set the focus on the widget.
        this.scrollOptions = undefined;
        this.toDispose.push(this.searchOptionsChangeEmitter);
    }
    init() {
        this.toDispose.pushAll([
            this.notificationCenter.onIndexDidUpdate(() => this.refresh(undefined)),
            this.notificationCenter.onDaemonDidStart(() => this.refresh(undefined)),
            this.notificationCenter.onDaemonDidStop(() => this.refresh(undefined)),
        ]);
    }
    onAfterShow(message) {
        this.maybeUpdateOnFirstRender();
        super.onAfterShow(message);
    }
    maybeUpdateOnFirstRender() {
        if (this.firstActivate) {
            this.firstActivate = false;
            this.update();
        }
    }
    onActivateRequest(message) {
        this.maybeUpdateOnFirstRender();
        super.onActivateRequest(message);
        (this.focusNode || this.node).focus();
    }
    onUpdateRequest(message) {
        super.onUpdateRequest(message);
        this.render();
    }
    onResize(message) {
        super.onResize(message);
        this.updateScrollBar();
    }
    async install({ item, progressId, version, }) {
        return this.options.installable.install({ item, progressId, version });
    }
    async uninstall({ item, progressId, }) {
        return this.options.installable.uninstall({ item, progressId });
    }
    render() {
        return (React.createElement(filterable_list_container_1.FilterableListContainer, { defaultSearchOptions: this.options.defaultSearchOptions, container: this, resolveFocus: this.onFocusResolved, searchable: this.options.searchable, install: this.install.bind(this), uninstall: this.uninstall.bind(this), itemLabel: this.options.itemLabel, itemDeprecated: this.options.itemDeprecated, itemRenderer: this.options.itemRenderer, filterRenderer: this.options.filterRenderer, searchOptionsDidChange: this.searchOptionsChangeEmitter.event, messageService: this.messageService, commandService: this.commandService, responseService: this.responseService }));
    }
    /**
     * If `filterText` is defined, sets the filter text to the argument.
     * If it is `undefined`, updates the view state by re-running the search with the current `filterText` term.
     */
    refresh(searchOptions) {
        this.searchOptionsChangeEmitter.fire(searchOptions);
    }
    updateScrollBar() {
        if (this.scrollBar) {
            this.scrollBar.update();
        }
    }
};
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], ListWidget.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(command_1.CommandService),
    __metadata("design:type", Object)
], ListWidget.prototype, "commandService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ResponseServiceClient),
    __metadata("design:type", Object)
], ListWidget.prototype, "responseService", void 0);
__decorate([
    (0, inversify_1.inject)(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], ListWidget.prototype, "notificationCenter", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ListWidget.prototype, "init", null);
ListWidget = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [Object])
], ListWidget);
exports.ListWidget = ListWidget;
//# sourceMappingURL=list-widget.js.map