"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchBar = void 0;
const common_1 = require("@theia/core/lib/common");
const React = require("@theia/core/shared/react");
class SearchBar extends React.Component {
    constructor(props) {
        super(props);
        this.setRef = (element) => {
            if (this.props.resolveFocus) {
                this.props.resolveFocus(element || undefined);
            }
        };
        this.handleFilterTextChange = this.handleFilterTextChange.bind(this);
    }
    render() {
        return (React.createElement("input", { ref: this.setRef, className: `theia-input ${SearchBar.Styles.SEARCH_BAR_CLASS}`, type: "text", placeholder: common_1.nls.localize('arduino/component/filterSearch', 'Filter your search...'), size: 1, value: this.props.filterText, onChange: this.handleFilterTextChange }));
    }
    handleFilterTextChange(event) {
        this.props.onFilterTextChanged(event.target.value);
    }
}
exports.SearchBar = SearchBar;
(function (SearchBar) {
    let Styles;
    (function (Styles) {
        Styles.SEARCH_BAR_CLASS = 'search-bar';
    })(Styles = SearchBar.Styles || (SearchBar.Styles = {}));
})(SearchBar = exports.SearchBar || (exports.SearchBar = {}));
//# sourceMappingURL=search-bar.js.map