"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchbookCommands = void 0;
const command_1 = require("@theia/core/lib/common/command");
var SketchbookCommands;
(function (SketchbookCommands) {
    SketchbookCommands.TOGGLE_SKETCHBOOK_WIDGET = {
        id: 'arduino-sketchbook-widget:toggle',
    };
    SketchbookCommands.REVEAL_SKETCH_NODE = {
        id: 'arduino-sketchbook--reveal-sketch-node',
    };
    SketchbookCommands.OPEN_NEW_WINDOW = command_1.Command.toLocalizedCommand({
        id: 'arduino-sketchbook--open-sketch-new-window',
        label: 'Open Sketch in New Window',
    }, 'arduino/sketch/openSketchInNewWindow');
    SketchbookCommands.REVEAL_IN_FINDER = command_1.Command.toLocalizedCommand({
        id: 'arduino-sketchbook--reveal-in-finder',
        label: 'Open Folder',
    }, 'arduino/sketch/openFolder');
    SketchbookCommands.OPEN_SKETCHBOOK_CONTEXT_MENU = {
        id: 'arduino-sketchbook--open-sketch-context-menu',
        label: 'Contextual menu',
        iconClass: 'sketchbook-tree__opts',
    };
    SketchbookCommands.SKETCHBOOK_HIDE_FILES = {
        id: 'arduino-sketchbook--hide-files',
        label: 'Contextual menu',
    };
    SketchbookCommands.SKETCHBOOK_SHOW_FILES = {
        id: 'arduino-sketchbook--show-files',
        label: 'Contextual menu',
    };
})(SketchbookCommands = exports.SketchbookCommands || (exports.SketchbookCommands = {}));
//# sourceMappingURL=sketchbook-commands.js.map