"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchbookTreeModel = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const browser_1 = require("@theia/filesystem/lib/browser");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const protocol_1 = require("../../../common/protocol");
const sketchbook_tree_1 = require("./sketchbook-tree");
const arduino_preferences_1 = require("../../arduino-preferences");
const tree_1 = require("@theia/core/lib/browser/tree");
const sketchbook_commands_1 = require("./sketchbook-commands");
const browser_2 = require("@theia/core/lib/browser");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const command_1 = require("@theia/core/lib/common/command");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const progress_service_1 = require("@theia/core/lib/common/progress-service");
const navigator_tree_1 = require("@theia/navigator/lib/browser/navigator-tree");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const disposable_1 = require("@theia/core/lib/common/disposable");
let SketchbookTreeModel = class SketchbookTreeModel extends browser_1.FileTreeModel {
    constructor() {
        super(...arguments);
        this.pendingBusyProgress = new Map();
    }
    init() {
        super.init();
        this.reportBusyProgress();
        this.initializeRoot();
    }
    reportBusyProgress() {
        this.toDispose.push(this.onDidChangeBusy((node) => {
            const pending = this.pendingBusyProgress.get(node.id);
            if (pending) {
                if (!node.busy) {
                    pending.resolve();
                    this.pendingBusyProgress.delete(node.id);
                }
                return;
            }
            if (node.busy) {
                const progress = new promise_util_1.Deferred();
                this.pendingBusyProgress.set(node.id, progress);
                this.progressService.withProgress('', 'explorer', () => progress.promise);
            }
        }));
        this.toDispose.push(disposable_1.Disposable.create(() => {
            for (const pending of this.pendingBusyProgress.values()) {
                pending.resolve();
            }
            this.pendingBusyProgress.clear();
        }));
    }
    async initializeRoot() {
        await Promise.all([
            this.applicationState.reachedState('initialized_layout'),
            this.workspaceService.roots,
        ]);
        await this.updateRoot();
        if (this.toDispose.disposed) {
            return;
        }
        this.toDispose.push(this.workspaceService.onWorkspaceChanged(() => this.updateRoot()));
        this.toDispose.push(this.workspaceService.onWorkspaceLocationChanged(() => this.updateRoot()));
        this.toDispose.push(this.arduinoPreferences.onPreferenceChanged(({ preferenceName }) => {
            if (preferenceName === 'arduino.sketchbook.showAllFiles') {
                this.updateRoot();
            }
        }));
        if (this.selectedNodes.length) {
            return;
        }
        const root = this.root;
        if (tree_1.CompositeTreeNode.is(root) && root.children.length === 1) {
            const child = root.children[0];
            if (tree_1.SelectableTreeNode.is(child) &&
                !child.selected &&
                tree_1.ExpandableTreeNode.is(child)) {
                this.selectNode(child);
                this.expandNode(child);
            }
        }
    }
    previewNode(node) {
        if (browser_1.FileNode.is(node)) {
            (0, browser_2.open)(this.openerService, node.uri, {
                mode: 'reveal',
                preview: true,
            });
        }
    }
    *getNodesByUri(uri) {
        const workspace = this.root;
        if (navigator_tree_1.WorkspaceNode.is(workspace)) {
            for (const root of workspace.children) {
                const id = this.tree.createId(root, uri);
                const node = this.getNode(id);
                if (node) {
                    yield node;
                }
            }
        }
    }
    async updateRoot() {
        this.root = await this.createRoot();
    }
    async createRoot() {
        const config = await this.configService.getConfiguration();
        const rootFileStats = await this.fileService.resolve(new uri_1.default(config.sketchDirUri));
        if (this.workspaceService.opened && rootFileStats.children) {
            // filter out libraries and hardware
            if (this.workspaceService.opened) {
                const workspaceNode = navigator_tree_1.WorkspaceNode.createRoot();
                workspaceNode.children.push(await this.tree.createWorkspaceRoot(rootFileStats, workspaceNode));
                return workspaceNode;
            }
        }
    }
    /**
     * Move the given source file or directory to the given target directory.
     */
    async move(source, target) {
        if (source.parent && navigator_tree_1.WorkspaceRootNode.is(source)) {
            // do not support moving a root folder
            return undefined;
        }
        return super.move(source, target);
    }
    /**
     * Reveals node in the navigator by given file uri.
     *
     * @param uri uri to file which should be revealed in the navigator
     * @returns file tree node if the file with given uri was revealed, undefined otherwise
     */
    async revealFile(uri) {
        if (!uri.path.isAbsolute) {
            return undefined;
        }
        let node = this.getNodeClosestToRootByUri(uri);
        // success stop condition
        // we have to reach workspace root because expanded node could be inside collapsed one
        if (navigator_tree_1.WorkspaceRootNode.is(node)) {
            if (tree_1.ExpandableTreeNode.is(node)) {
                if (!node.expanded) {
                    node = await this.expandNode(node);
                }
                return node;
            }
            // shouldn't happen, root node is always directory, i.e. expandable
            return undefined;
        }
        // fail stop condition
        if (uri.path.isRoot) {
            // file system root is reached but workspace root wasn't found, it means that
            // given uri is not in workspace root folder or points to not existing file.
            return undefined;
        }
        if (await this.revealFile(uri.parent)) {
            if (node === undefined) {
                // get node if it wasn't mounted into navigator tree before expansion
                node = this.getNodeClosestToRootByUri(uri);
            }
            if (tree_1.ExpandableTreeNode.is(node) && !node.expanded) {
                node = await this.expandNode(node);
            }
            return node;
        }
        return undefined;
    }
    getNodeClosestToRootByUri(uri) {
        const nodes = [...this.getNodesByUri(uri)];
        return nodes.length > 0
            ? nodes.reduce((node1, node2 // return the node closest to the workspace root
            ) => (node1.id.length >= node2.id.length ? node1 : node2))
            : undefined;
    }
    // selectNode gets called when the user single-clicks on an item
    // when this happens, we want to open the file if it belongs to the currently open sketch
    async selectNode(node) {
        super.selectNode(node);
        if (browser_1.FileNode.is(node) && (await this.isFileInsideCurrentSketch(node))) {
            this.open(node.uri);
        }
    }
    open(uri) {
        (0, browser_2.open)(this.openerService, uri, {
            mode: 'reveal',
            preview: false,
        });
    }
    async doOpenNode(node) {
        // if it's a sketch dir, or a file from another sketch, open in new window
        if (!(await this.isFileInsideCurrentSketch(node))) {
            const sketchRoot = this.recursivelyFindSketchRoot(node);
            if (sketchRoot) {
                this.commandRegistry.executeCommand(sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.id, { node: sketchRoot });
            }
            return;
        }
        if (node.visible === false) {
            return;
        }
        else if (browser_1.FileNode.is(node)) {
            this.open(node.uri);
        }
        else {
            super.doOpenNode(node);
        }
    }
    async isFileInsideCurrentSketch(node) {
        // it's a directory, not a file
        if (!browser_1.FileNode.is(node)) {
            return false;
        }
        // check if the node is a file that belongs to another sketch
        const sketch = await this.sketchServiceClient.currentSketch();
        if (sketches_service_client_impl_1.CurrentSketch.isValid(sketch) &&
            node.uri.toString().indexOf(sketch.uri) !== 0) {
            return false;
        }
        return true;
    }
    recursivelyFindSketchRoot(node) {
        if (node && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(node)) {
            return node;
        }
        if (node && node.parent) {
            return this.recursivelyFindSketchRoot(node.parent);
        }
        // can't find a root, return false
        return false;
    }
};
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SketchbookTreeModel.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], SketchbookTreeModel.prototype, "arduinoPreferences", void 0);
__decorate([
    (0, inversify_1.inject)(command_1.CommandRegistry),
    __metadata("design:type", command_1.CommandRegistry)
], SketchbookTreeModel.prototype, "commandRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.ConfigService),
    __metadata("design:type", Object)
], SketchbookTreeModel.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.OpenerService),
    __metadata("design:type", Object)
], SketchbookTreeModel.prototype, "openerService", void 0);
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], SketchbookTreeModel.prototype, "sketchServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(sketchbook_tree_1.SketchbookTree),
    __metadata("design:type", sketchbook_tree_1.SketchbookTree)
], SketchbookTreeModel.prototype, "tree", void 0);
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], SketchbookTreeModel.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], SketchbookTreeModel.prototype, "applicationState", void 0);
__decorate([
    (0, inversify_1.inject)(progress_service_1.ProgressService),
    __metadata("design:type", progress_service_1.ProgressService)
], SketchbookTreeModel.prototype, "progressService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SketchbookTreeModel.prototype, "init", null);
SketchbookTreeModel = __decorate([
    (0, inversify_1.injectable)()
], SketchbookTreeModel);
exports.SketchbookTreeModel = SketchbookTreeModel;
//# sourceMappingURL=sketchbook-tree-model.js.map