"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchbookTree = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const file_tree_1 = require("@theia/filesystem/lib/browser/file-tree");
const protocol_1 = require("../../../common/protocol");
const sketchbook_commands_1 = require("./sketchbook-commands");
const navigator_tree_1 = require("@theia/navigator/lib/browser/navigator-tree");
const arduino_preferences_1 = require("../../arduino-preferences");
let SketchbookTree = class SketchbookTree extends navigator_tree_1.FileNavigatorTree {
    async resolveChildren(parent) {
        const showAllFiles = this.arduinoPreferences['arduino.sketchbook.showAllFiles'];
        const children = (await super.resolveChildren(parent)).filter((child) => {
            // strip libraries and hardware directories
            if (file_tree_1.DirNode.is(child) &&
                ['libraries', 'hardware'].includes(child.fileStat.name) &&
                navigator_tree_1.WorkspaceRootNode.is(child.parent)) {
                return false;
            }
            // strip files if only directories are admitted
            if (!file_tree_1.DirNode.is(child) && !showAllFiles) {
                return false;
            }
            // strip hidden files
            if (file_tree_1.FileStatNode.is(child) && child.fileStat.name.indexOf('.') === 0) {
                return false;
            }
            return true;
        });
        if (file_tree_1.DirNode.is(parent) && children.length === 0) {
            delete parent.expanded;
        }
        return await Promise.all(children.map(async (childNode) => await this.decorateNode(childNode, showAllFiles)));
    }
    async isSketchNode(node) {
        const sketch = await this.sketchesService.maybeLoadSketch(node.uri.toString());
        return !!sketch;
    }
    /**
     * Add commands available for the given node
     * @param node
     * @returns
     */
    async augmentSketchNode(node) {
        Object.assign(node, {
            type: 'sketch',
            commands: [sketchbook_commands_1.SketchbookCommands.OPEN_SKETCHBOOK_CONTEXT_MENU],
        });
    }
    async decorateNode(node, showAllFiles) {
        if (file_tree_1.DirNode.is(node) && (await this.isSketchNode(node))) {
            await this.augmentSketchNode(node);
            if (!showAllFiles) {
                delete node.expanded;
                node.children = [];
            }
            else {
                node.expanded = 'expanded' in node ? node.expanded : false;
            }
        }
        return node;
    }
};
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], SketchbookTree.prototype, "sketchesService", void 0);
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], SketchbookTree.prototype, "arduinoPreferences", void 0);
SketchbookTree = __decorate([
    (0, inversify_1.injectable)()
], SketchbookTree);
exports.SketchbookTree = SketchbookTree;
(function (SketchbookTree) {
    let SketchDirNode;
    (function (SketchDirNode) {
        function is(node) {
            return !!node && node.type === 'sketch' && file_tree_1.DirNode.is(node);
        }
        SketchDirNode.is = is;
    })(SketchDirNode = SketchbookTree.SketchDirNode || (SketchbookTree.SketchDirNode = {}));
})(SketchbookTree = exports.SketchbookTree || (exports.SketchbookTree = {}));
exports.SketchbookTree = SketchbookTree;
//# sourceMappingURL=sketchbook-tree.js.map