"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchbookWidgetContribution = exports.SKETCHBOOK__CONTEXT__MAIN_GROUP = exports.SKETCHBOOK__CONTEXT = void 0;
const remote = require("@theia/core/electron-shared/@electron/remote");
const inversify_1 = require("@theia/core/shared/inversify");
const menu_1 = require("@theia/core/lib/common/menu");
const preference_service_1 = require("@theia/core/lib/browser/preferences/preference-service");
const view_contribution_1 = require("@theia/core/lib/browser/shell/view-contribution");
const main_menu_manager_1 = require("../../../common/main-menu-manager");
const arduino_preferences_1 = require("../../arduino-preferences");
const sketchbook_widget_1 = require("./sketchbook-widget");
const arduino_menus_1 = require("../../menu/arduino-menus");
const sketchbook_tree_1 = require("./sketchbook-tree");
const sketchbook_commands_1 = require("./sketchbook-commands");
const workspace_service_1 = require("../../theia/workspace/workspace-service");
const browser_1 = require("@theia/core/lib/browser");
const disposable_1 = require("@theia/core/lib/common/disposable");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const contribution_1 = require("../../contributions/contribution");
exports.SKETCHBOOK__CONTEXT = ['arduino-sketchbook--context'];
// `Open Folder`, `Open in New Window`
exports.SKETCHBOOK__CONTEXT__MAIN_GROUP = [
    ...exports.SKETCHBOOK__CONTEXT,
    '0_main',
];
let SketchbookWidgetContribution = class SketchbookWidgetContribution extends view_contribution_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: 'arduino-sketchbook-widget',
            widgetName: sketchbook_widget_1.SketchbookWidget.LABEL,
            defaultWidgetOptions: {
                area: 'left',
                rank: 1,
            },
            toggleCommandId: sketchbook_commands_1.SketchbookCommands.TOGGLE_SKETCHBOOK_WIDGET.id,
            toggleKeybinding: 'CtrlCmd+Shift+B',
        });
        this.toDisposeBeforeNewContextMenu = new disposable_1.DisposableCollection();
    }
    onStart() {
        this.shell.onDidChangeCurrentWidget(() => this.onCurrentWidgetChangedHandler());
        this.arduinoPreferences.onPreferenceChanged(({ preferenceName }) => {
            if (preferenceName === 'arduino.sketchbook.showAllFiles') {
                this.mainMenuManager.update();
            }
        });
    }
    async initializeLayout() {
        return this.openView();
    }
    registerCommands(registry) {
        super.registerCommands(registry);
        registry.registerCommand(sketchbook_commands_1.SketchbookCommands.REVEAL_SKETCH_NODE, {
            execute: (treeWidgetId, nodeUri) => this.revealSketchNode(treeWidgetId, nodeUri),
        });
        registry.registerCommand(sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW, {
            execute: (arg) => this.openNewWindow(arg.node),
            isEnabled: (arg) => !!arg && 'node' in arg && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(arg.node),
            isVisible: (arg) => !!arg && 'node' in arg && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(arg.node),
        });
        registry.registerCommand(sketchbook_commands_1.SketchbookCommands.REVEAL_IN_FINDER, {
            execute: async (arg) => {
                if (arg.node.uri) {
                    const exists = await this.fileService.exists(new contribution_1.URI(arg.node.uri));
                    if (exists) {
                        const fsPath = await this.fileService.fsPath(new contribution_1.URI(arg.node.uri));
                        if (fsPath) {
                            remote.shell.openPath(fsPath);
                        }
                    }
                }
            },
            isEnabled: (arg) => !!arg && 'node' in arg && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(arg.node),
            isVisible: (arg) => !!arg && 'node' in arg && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(arg.node),
        });
        registry.registerCommand(sketchbook_commands_1.SketchbookCommands.OPEN_SKETCHBOOK_CONTEXT_MENU, {
            isEnabled: (arg) => !!arg && 'node' in arg && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(arg.node),
            isVisible: (arg) => !!arg && 'node' in arg && sketchbook_tree_1.SketchbookTree.SketchDirNode.is(arg.node),
            execute: async (arg) => {
                // cleanup previous context menu entries
                this.toDisposeBeforeNewContextMenu.dispose();
                const container = arg.event.target;
                if (!container) {
                    return;
                }
                // disable the "open sketch" command for the current sketch.
                // otherwise make the command clickable
                const currentSketch = await this.sketchServiceClient.currentSketch();
                if (sketches_service_client_impl_1.CurrentSketch.isValid(currentSketch) &&
                    currentSketch.uri === arg.node.uri.toString()) {
                    const placeholder = new arduino_menus_1.PlaceholderMenuNode(exports.SKETCHBOOK__CONTEXT__MAIN_GROUP, sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.label);
                    this.menuRegistry.registerMenuNode(exports.SKETCHBOOK__CONTEXT__MAIN_GROUP, placeholder);
                    this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(placeholder.id)));
                }
                else {
                    this.menuRegistry.registerMenuAction(exports.SKETCHBOOK__CONTEXT__MAIN_GROUP, {
                        commandId: sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.id,
                        label: sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.label,
                    });
                    this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW)));
                }
                const options = {
                    menuPath: exports.SKETCHBOOK__CONTEXT,
                    anchor: {
                        x: container.getBoundingClientRect().left,
                        y: container.getBoundingClientRect().top + container.offsetHeight,
                    },
                    args: [arg],
                };
                this.contextMenuRenderer.render(options);
            },
        });
    }
    registerMenus(registry) {
        super.registerMenus(registry);
        // unregister main menu action
        registry.unregisterMenuAction({
            commandId: sketchbook_commands_1.SketchbookCommands.TOGGLE_SKETCHBOOK_WIDGET.id,
        });
        registry.registerMenuAction(exports.SKETCHBOOK__CONTEXT__MAIN_GROUP, {
            commandId: sketchbook_commands_1.SketchbookCommands.REVEAL_IN_FINDER.id,
            label: sketchbook_commands_1.SketchbookCommands.REVEAL_IN_FINDER.label,
            order: '0',
        });
    }
    openNewWindow(node) {
        const widget = this.tryGetWidget();
        if (widget) {
            const treeWidgetId = widget.activeTreeWidgetId();
            if (!treeWidgetId) {
                console.warn(`Could not retrieve active sketchbook tree ID.`);
                return;
            }
            const nodeUri = node.uri.toString();
            const options = {};
            Object.assign(options, {
                tasks: [
                    {
                        command: sketchbook_commands_1.SketchbookCommands.REVEAL_SKETCH_NODE.id,
                        args: [treeWidgetId, nodeUri],
                    },
                ],
            });
            return this.workspaceService.open(node.uri, options);
        }
    }
    /**
     * Reveals and selects node in the file navigator to which given widget is related.
     * Does nothing if given widget undefined or doesn't have related resource.
     *
     * @param widget widget file resource of which should be revealed and selected
     */
    async selectWidgetFileNode(widget) {
        if (browser_1.Navigatable.is(widget)) {
            const resourceUri = widget.getResourceUri();
            if (resourceUri) {
                const treeWidget = (await this.widget).getTreeWidget();
                const { model } = treeWidget;
                const node = await model.revealFile(resourceUri);
                if (browser_1.SelectableTreeNode.is(node)) {
                    model.selectNode(node);
                }
            }
        }
    }
    onCurrentWidgetChangedHandler() {
        this.selectWidgetFileNode(this.shell.currentWidget);
    }
    async revealSketchNode(treeWidgetId, nodeUIri) {
        return this.widget
            .then((widget) => this.shell.activateWidget(widget.id))
            .then((widget) => {
            if (widget instanceof sketchbook_widget_1.SketchbookWidget) {
                return widget.revealSketchNode(treeWidgetId, nodeUIri);
            }
        });
    }
};
__decorate([
    (0, inversify_1.inject)(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], SketchbookWidgetContribution.prototype, "arduinoPreferences", void 0);
__decorate([
    (0, inversify_1.inject)(preference_service_1.PreferenceService),
    __metadata("design:type", Object)
], SketchbookWidgetContribution.prototype, "preferenceService", void 0);
__decorate([
    (0, inversify_1.inject)(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], SketchbookWidgetContribution.prototype, "mainMenuManager", void 0);
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], SketchbookWidgetContribution.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], SketchbookWidgetContribution.prototype, "menuRegistry", void 0);
__decorate([
    (0, inversify_1.inject)(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], SketchbookWidgetContribution.prototype, "sketchServiceClient", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], SketchbookWidgetContribution.prototype, "contextMenuRenderer", void 0);
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SketchbookWidgetContribution.prototype, "fileService", void 0);
SketchbookWidgetContribution = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], SketchbookWidgetContribution);
exports.SketchbookWidgetContribution = SketchbookWidgetContribution;
//# sourceMappingURL=sketchbook-widget-contribution.js.map