"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var SketchbookWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoopDragOverDockPanel = exports.SketchbookWidget = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const algorithm_1 = require("@theia/core/shared/@phosphor/algorithm");
const widgets_1 = require("@theia/core/shared/@phosphor/widgets");
const messaging_1 = require("@theia/core/shared/@phosphor/messaging");
const disposable_1 = require("@theia/core/lib/common/disposable");
const widget_1 = require("@theia/core/lib/browser/widgets/widget");
const sketchbook_tree_widget_1 = require("./sketchbook-tree-widget");
const common_1 = require("@theia/core/lib/common");
const cloud_sketchbook_composite_widget_1 = require("../cloud-sketchbook/cloud-sketchbook-composite-widget");
const contribution_1 = require("../../contributions/contribution");
let SketchbookWidget = SketchbookWidget_1 = class SketchbookWidget extends widget_1.BaseWidget {
    constructor() {
        super();
        this.id = 'arduino-sketchbook-widget';
        this.title.caption = SketchbookWidget_1.LABEL;
        this.title.label = SketchbookWidget_1.LABEL;
        this.title.iconClass = 'fa fa-arduino-folder';
        this.title.closable = true;
        this.node.tabIndex = 0;
        this.sketchbookTreesContainer = this.createTreesContainer();
    }
    init() {
        this.sketchbookTreesContainer.addWidget(this.localSketchbookTreeWidget);
    }
    onAfterAttach(message) {
        super.onAfterAttach(message);
        widgets_1.Widget.attach(this.sketchbookTreesContainer, this.node);
        this.toDisposeOnDetach.push(disposable_1.Disposable.create(() => widgets_1.Widget.detach(this.sketchbookTreesContainer)));
    }
    getTreeWidget() {
        return this.localSketchbookTreeWidget;
    }
    activeTreeWidgetId() {
        const selectedTreeWidgets = (0, algorithm_1.toArray)(this.sketchbookTreesContainer.selectedWidgets()).map(({ id }) => id);
        if (selectedTreeWidgets.length > 1) {
            console.warn(`Found multiple selected tree widgets: ${JSON.stringify(selectedTreeWidgets)}. Expected only one.`);
        }
        return selectedTreeWidgets.shift();
    }
    async revealSketchNode(treeWidgetId, nodeUri) {
        const widget = (0, algorithm_1.toArray)(this.sketchbookTreesContainer.widgets())
            .filter(({ id }) => id === treeWidgetId)
            .shift();
        if (!widget) {
            console.warn(`Could not find tree widget with ID: ${widget}`);
            return;
        }
        // TODO: remove this when the remote/local sketchbooks and their widgets are cleaned up.
        const findTreeWidget = (widget) => {
            if (widget instanceof sketchbook_tree_widget_1.SketchbookTreeWidget) {
                return widget;
            }
            if (widget instanceof cloud_sketchbook_composite_widget_1.CloudSketchbookCompositeWidget) {
                return widget.getTreeWidget();
            }
            return undefined;
        };
        const treeWidget = findTreeWidget((0, algorithm_1.toArray)(this.sketchbookTreesContainer.widgets())
            .filter(({ id }) => id === treeWidgetId)
            .shift());
        if (!treeWidget) {
            console.warn(`Could not find tree widget with ID: ${treeWidget}`);
            return;
        }
        this.sketchbookTreesContainer.activateWidget(widget);
        const treeNode = await treeWidget.model.revealFile(new contribution_1.URI(nodeUri));
        if (!treeNode) {
            console.warn(`Could not find tree node with URI: ${nodeUri}`);
        }
    }
    onActivateRequest(message) {
        super.onActivateRequest(message);
        // TODO: focus the active sketchbook
        // if (this.editor) {
        //     this.editor.focus();
        // } else {
        // }
        this.node.focus();
    }
    onResize(message) {
        super.onResize(message);
        messaging_1.MessageLoop.sendMessage(this.sketchbookTreesContainer, widgets_1.Widget.ResizeMessage.UnknownSize);
        for (const widget of (0, algorithm_1.toArray)(this.sketchbookTreesContainer.widgets())) {
            messaging_1.MessageLoop.sendMessage(widget, widgets_1.Widget.ResizeMessage.UnknownSize);
        }
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.onResize(widgets_1.Widget.ResizeMessage.UnknownSize);
    }
    createTreesContainer() {
        const panel = new NoopDragOverDockPanel({
            spacing: 0,
            mode: 'single-document',
        });
        panel.addClass('sketchbook-trees-container');
        panel.node.tabIndex = -1;
        return panel;
    }
};
SketchbookWidget.LABEL = common_1.nls.localize('arduino/sketch/titleSketchbook', 'Sketchbook');
__decorate([
    (0, inversify_1.inject)(sketchbook_tree_widget_1.SketchbookTreeWidget),
    __metadata("design:type", sketchbook_tree_widget_1.SketchbookTreeWidget)
], SketchbookWidget.prototype, "localSketchbookTreeWidget", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SketchbookWidget.prototype, "init", null);
SketchbookWidget = SketchbookWidget_1 = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], SketchbookWidget);
exports.SketchbookWidget = SketchbookWidget;
class NoopDragOverDockPanel extends widgets_1.DockPanel {
    constructor(options) {
        super(options);
        NoopDragOverDockPanel.prototype['_evtDragOver'] = (event) => {
            event.preventDefault();
            event.stopPropagation();
            event.dropAction = 'none';
        };
    }
}
exports.NoopDragOverDockPanel = NoopDragOverDockPanel;
//# sourceMappingURL=sketchbook-widget.js.map