"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartupTask = exports.StartupTasks = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const contribution_1 = require("../../contributions/contribution");
const window_1 = require("../../utils/window");
let StartupTasks = class StartupTasks extends contribution_1.Contribution {
    onReady() {
        const tasks = StartupTask.get(new URL(window.location.href));
        console.log(`Executing startup tasks: ${JSON.stringify(tasks)}`);
        tasks.forEach(({ command, args = [] }) => this.commandService
            .executeCommand(command, ...args)
            .catch((err) => console.error(`Error occurred when executing the startup task '${command}'${(args === null || args === void 0 ? void 0 : args.length) ? ` with args: '${JSON.stringify(args)}` : ''}.`, err)));
        if (tasks.length) {
            // Remove the startup tasks after the execution.
            // Otherwise, IDE2 executes them again on a window reload event.
            (0, window_1.setURL)(StartupTask.set([], new URL(window.location.href)));
            console.info(`Removed startup tasks from URL.`);
        }
    }
};
StartupTasks = __decorate([
    (0, inversify_1.injectable)()
], StartupTasks);
exports.StartupTasks = StartupTasks;
var StartupTask;
(function (StartupTask) {
    const QUERY = 'startupTasks';
    function is(arg) {
        if (typeof arg === 'object') {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const object = arg;
            return 'command' in object && typeof object['command'] === 'string';
        }
        return false;
    }
    StartupTask.is = is;
    function get(url) {
        const { searchParams } = url;
        const encodedTasks = searchParams.get(QUERY);
        if (encodedTasks) {
            const rawTasks = decodeURIComponent(encodedTasks);
            const tasks = JSON.parse(rawTasks);
            if (Array.isArray(tasks)) {
                return tasks.filter((task) => {
                    if (StartupTask.is(task)) {
                        return true;
                    }
                    console.warn(`Was not a task: ${JSON.stringify(task)}. Ignoring.`);
                    return false;
                });
            }
            else {
                debugger;
                console.warn(`Startup tasks was not an array: ${rawTasks}. Ignoring.`);
            }
        }
        return [];
    }
    StartupTask.get = get;
    function set(tasks, url) {
        const copy = new URL(url);
        copy.searchParams.set(QUERY, encodeURIComponent(JSON.stringify(tasks)));
        return copy;
    }
    StartupTask.set = set;
    function append(tasks, url) {
        return set([...get(url), ...tasks], url);
    }
    StartupTask.append = append;
})(StartupTask = exports.StartupTask || (exports.StartupTask = {}));
(function (StartupTasks) {
    let WorkspaceInput;
    (function (WorkspaceInput) {
        function is(input) {
            return !!input && !!input.tasks;
        }
        WorkspaceInput.is = is;
    })(WorkspaceInput = StartupTasks.WorkspaceInput || (StartupTasks.WorkspaceInput = {}));
})(StartupTasks = exports.StartupTasks || (exports.StartupTasks = {}));
exports.StartupTasks = StartupTasks;
//# sourceMappingURL=startup-task.js.map