"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.duration = void 0;
const fast_safe_stringify_1 = require("fast-safe-stringify");
function duration(options) {
    return (_target, key, descriptor) => {
        const original = descriptor.value;
        descriptor.value = async function (...args) {
            var _a, _b;
            const input = args
                .filter((arg) => !Boolean(isCancellationToken(arg)))
                .map(stringify)
                .join(',');
            const start = performance.now();
            const result = await original.apply(this, args);
            const end = performance.now();
            const duration = end - start;
            const slow = duration > ((_a = options === null || options === void 0 ? void 0 : options.timeout) !== null && _a !== void 0 ? _a : 100);
            const message = `---- ${slow ? '!!!SLOW!!! ' : ''}DURATION: ${(_b = options === null || options === void 0 ? void 0 : options.name) !== null && _b !== void 0 ? _b : String(key)} took ${duration.toFixed(3)} ms. Args: [${input}] ----`;
            if (slow) {
                console.error(message);
            }
            else {
                console.info(message);
            }
            return result;
        };
        return descriptor;
    };
}
exports.duration = duration;
function stringify(arg) {
    try {
        return JSON.stringify(arg);
    }
    catch (_a) {
        return (0, fast_safe_stringify_1.default)(arg);
    }
}
// The cancellation token is implicitly the last arg of the JSON-RPC invocation. We want to filter it out from the logs.
// See: https://github.com/eclipse-theia/theia/issues/10129
function isCancellationToken(arg) {
    return (typeof arg === 'object' &&
        arg !== null &&
        'onCancellationRequested' in arg &&
        'isCancellationRequested' in arg);
}
//# sourceMappingURL=decorators.js.map