"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CoreService = exports.CoreServicePath = exports.CoreError = exports.CompilerWarningLiterals = void 0;
const application_error_1 = require("@theia/core/lib/common/application-error");
exports.CompilerWarningLiterals = [
    'None',
    'Default',
    'More',
    'All',
];
var CoreError;
(function (CoreError) {
    let ErrorLocationRef;
    (function (ErrorLocationRef) {
        function equals(left, right) {
            return (left.message === right.message &&
                left.details === right.details &&
                equalsLocation(left.location, right.location));
        }
        ErrorLocationRef.equals = equals;
        function equalsLocation(left, right) {
            return left.uri === right.uri && equalsRange(left.range, right.range);
        }
        function equalsRange(left, right) {
            return (equalsPosition(left.start, right.start) &&
                equalsPosition(left.end, right.end));
        }
        function equalsPosition(left, right) {
            return left.character === right.character && left.line === right.line;
        }
    })(ErrorLocationRef = CoreError.ErrorLocationRef || (CoreError.ErrorLocationRef = {}));
    CoreError.Codes = {
        Verify: 4001,
        Upload: 4002,
        UploadUsingProgrammer: 4003,
        BurnBootloader: 4004,
    };
    CoreError.VerifyFailed = create(CoreError.Codes.Verify);
    CoreError.UploadFailed = create(CoreError.Codes.Upload);
    CoreError.UploadUsingProgrammerFailed = create(CoreError.Codes.UploadUsingProgrammer);
    CoreError.BurnBootloaderFailed = create(CoreError.Codes.BurnBootloader);
    function is(error) {
        return (error instanceof Error &&
            application_error_1.ApplicationError.is(error) &&
            Object.values(CoreError.Codes).includes(error.code));
    }
    CoreError.is = is;
    function create(code) {
        return application_error_1.ApplicationError.declare(code, (message, data) => {
            return {
                data,
                message,
            };
        });
    }
})(CoreError = exports.CoreError || (exports.CoreError = {}));
exports.CoreServicePath = '/services/core-service';
exports.CoreService = Symbol('CoreService');
//# sourceMappingURL=core-service.js.map