"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryPackage = exports.LibraryLocation = exports.LibrarySearch = exports.LibraryService = exports.LibraryServicePath = void 0;
const arduino_component_1 = require("./arduino-component");
const nls_1 = require("@theia/core/lib/common/nls");
const nls_2 = require("../nls");
exports.LibraryServicePath = '/services/library-service';
exports.LibraryService = Symbol('LibraryService');
var LibrarySearch;
(function (LibrarySearch) {
    LibrarySearch.TypeLiterals = [
        'All',
        'Updatable',
        'Installed',
        'Arduino',
        'Partner',
        'Recommended',
        'Contributed',
        'Retired',
    ];
    LibrarySearch.TypeLabels = {
        All: nls_2.All,
        Updatable: nls_2.Updatable,
        Installed: nls_1.nls.localize('arduino/libraryType/installed', 'Installed'),
        Arduino: 'Arduino',
        Partner: nls_2.Partner,
        Recommended: nls_2.Recommended,
        Contributed: nls_2.Contributed,
        Retired: nls_2.Retired,
    };
    LibrarySearch.TopicLiterals = [
        'All',
        'Communication',
        'Data Processing',
        'Data Storage',
        'Device Control',
        'Display',
        'Other',
        'Sensors',
        'Signal Input/Output',
        'Timing',
        'Uncategorized',
    ];
    LibrarySearch.TopicLabels = {
        All: nls_2.All,
        Communication: nls_1.nls.localize('arduino/libraryTopic/communication', 'Communication'),
        'Data Processing': nls_1.nls.localize('arduino/libraryTopic/dataProcessing', 'Data Processing'),
        'Data Storage': nls_1.nls.localize('arduino/libraryTopic/dataStorage', 'Data Storage'),
        'Device Control': nls_1.nls.localize('arduino/libraryTopic/deviceControl', 'Device Control'),
        Display: nls_1.nls.localize('arduino/libraryTopic/display', 'Display'),
        Other: nls_1.nls.localize('arduino/libraryTopic/other', 'Other'),
        Sensors: nls_1.nls.localize('arduino/libraryTopic/sensors', 'Sensors'),
        'Signal Input/Output': nls_1.nls.localize('arduino/libraryTopic/signalInputOutput', 'Signal Input/Output'),
        Timing: nls_1.nls.localize('arduino/libraryTopic/timing', 'Timing'),
        Uncategorized: nls_1.nls.localize('arduino/libraryTopic/uncategorized', 'Uncategorized'),
    };
    LibrarySearch.PropertyLabels = {
        topic: nls_1.nls.localize('arduino/librarySearchProperty/topic', 'Topic'),
        type: nls_2.Type,
    };
})(LibrarySearch = exports.LibrarySearch || (exports.LibrarySearch = {}));
var LibraryLocation;
(function (LibraryLocation) {
    /**
     * In the `libraries` subdirectory of the Arduino IDE installation.
     */
    LibraryLocation[LibraryLocation["BUILTIN"] = 0] = "BUILTIN";
    /**
     * In the `libraries` subdirectory of the user directory (sketchbook).
     */
    LibraryLocation[LibraryLocation["USER"] = 1] = "USER";
    /**
     * In the `libraries` subdirectory of a platform.
     */
    LibraryLocation[LibraryLocation["PLATFORM_BUILTIN"] = 2] = "PLATFORM_BUILTIN";
    /**
     * When `LibraryLocation` is used in a context where a board is specified, this indicates the library is in the `libraries`
     * subdirectory of a platform referenced by the board's platform.
     */
    LibraryLocation[LibraryLocation["REFERENCED_PLATFORM_BUILTIN"] = 3] = "REFERENCED_PLATFORM_BUILTIN";
})(LibraryLocation = exports.LibraryLocation || (exports.LibraryLocation = {}));
var LibraryPackage;
(function (LibraryPackage) {
    function is(arg) {
        return (arduino_component_1.ArduinoComponent.is(arg) &&
            'includes' in arg &&
            Array.isArray(arg['includes']));
    }
    LibraryPackage.is = is;
    function equals(left, right) {
        return left.name === right.name && left.author === right.author;
    }
    LibraryPackage.equals = equals;
    function groupByLocation(packages) {
        const user = [];
        const rest = [];
        for (const pkg of packages) {
            if (pkg.location === LibraryLocation.USER) {
                user.push(pkg);
            }
            else {
                rest.push(pkg);
            }
        }
        return { user, rest };
    }
    LibraryPackage.groupByLocation = groupByLocation;
})(LibraryPackage = exports.LibraryPackage || (exports.LibraryPackage = {}));
//# sourceMappingURL=library-service.js.map