"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.Monitor = exports.MonitorManagerProxyClient = exports.MonitorManagerProxy = exports.MonitorManagerProxyPath = exports.MonitorManagerProxyFactory = void 0;
exports.MonitorManagerProxyFactory = Symbol('MonitorManagerProxyFactory');
exports.MonitorManagerProxyPath = '/services/monitor-manager-proxy';
exports.MonitorManagerProxy = Symbol('MonitorManagerProxy');
exports.MonitorManagerProxyClient = Symbol('MonitorManagerProxyClient');
var Monitor;
(function (Monitor) {
    // Commands sent by the clients to the web socket server
    let ClientCommand;
    (function (ClientCommand) {
        ClientCommand["SEND_MESSAGE"] = "SEND_MESSAGE";
        ClientCommand["CHANGE_SETTINGS"] = "CHANGE_SETTINGS";
    })(ClientCommand = Monitor.ClientCommand || (Monitor.ClientCommand = {}));
    // Commands sent by the backend to the clients
    let MiddlewareCommand;
    (function (MiddlewareCommand) {
        MiddlewareCommand["ON_SETTINGS_DID_CHANGE"] = "ON_SETTINGS_DID_CHANGE";
    })(MiddlewareCommand = Monitor.MiddlewareCommand || (Monitor.MiddlewareCommand = {}));
})(Monitor = exports.Monitor || (exports.Monitor = {}));
var Status;
(function (Status) {
    function isOK(status) {
        return !!status && typeof status.message !== 'string';
    }
    Status.isOK = isOK;
    Status.OK = {};
    Status.NOT_CONNECTED = { message: 'Not connected.' };
    Status.ALREADY_CONNECTED = {
        message: 'Already connected.',
    };
    Status.CONFIG_MISSING = {
        message: 'Serial Config missing.',
    };
    Status.UPLOAD_IN_PROGRESS = {
        message: 'Upload in progress.',
    };
})(Status = exports.Status || (exports.Status = {}));
//# sourceMappingURL=monitor-service.js.map