"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteWithProgress = void 0;
const cancellation_1 = require("@theia/core/lib/common/cancellation");
var ExecuteWithProgress;
(function (ExecuteWithProgress) {
    async function doWithProgress(options) {
        return withProgress(options.progressText, options.messageService, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        async (progress, _token) => {
            const progressId = progress.id;
            const toDispose = options.responseService.onProgressDidChange((progressMessage) => {
                if (progressId === progressMessage.progressId) {
                    const { message, work } = progressMessage;
                    progress.report({ message, work });
                }
            });
            try {
                if (!options.keepOutput) {
                    options.responseService.clearOutput();
                }
                const result = await options.run({ progressId });
                return result;
            }
            finally {
                toDispose.dispose();
            }
        });
    }
    ExecuteWithProgress.doWithProgress = doWithProgress;
    async function withProgress(text, messageService, cb) {
        const cancellationSource = new cancellation_1.CancellationTokenSource();
        const { token } = cancellationSource;
        const progress = await messageService.showProgress({ text, options: { cancelable: false } }, () => cancellationSource.cancel());
        try {
            const result = await cb(progress, token);
            return result;
        }
        finally {
            progress.cancel();
        }
    }
    ExecuteWithProgress.withProgress = withProgress;
})(ExecuteWithProgress = exports.ExecuteWithProgress || (exports.ExecuteWithProgress = {}));
//# sourceMappingURL=progressible.js.map