"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseServiceClient = exports.ResponseService = exports.ResponseServicePath = exports.ProgressMessage = exports.OutputMessage = void 0;
var OutputMessage;
(function (OutputMessage) {
    let Severity;
    (function (Severity) {
        Severity[Severity["Error"] = 0] = "Error";
        Severity[Severity["Warning"] = 1] = "Warning";
        Severity[Severity["Info"] = 2] = "Info";
    })(Severity = OutputMessage.Severity || (OutputMessage.Severity = {}));
})(OutputMessage = exports.OutputMessage || (exports.OutputMessage = {}));
var ProgressMessage;
(function (ProgressMessage) {
    function is(arg) {
        if (typeof arg === 'object') {
            const object = arg;
            return ('progressId' in object &&
                typeof object.progressId === 'string' &&
                'message' in object &&
                typeof object.message === 'string');
        }
        return false;
    }
    ProgressMessage.is = is;
})(ProgressMessage = exports.ProgressMessage || (exports.ProgressMessage = {}));
exports.ResponseServicePath = '/services/response-service';
exports.ResponseService = Symbol('ResponseService');
exports.ResponseServiceClient = Symbol('ResponseServiceClient');
//# sourceMappingURL=response-service.js.map