"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchesServiceClientImpl = exports.CurrentSketch = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const event_1 = require("@theia/core/lib/common/event");
const objects_1 = require("@theia/core/lib/common/objects");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const message_service_1 = require("@theia/core/lib/common/message-service");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const disposable_1 = require("@theia/core/lib/common/disposable");
const protocol_1 = require("../../common/protocol");
const config_service_1 = require("./config-service");
const sketches_service_1 = require("./sketches-service");
const constants_1 = require("../../browser/utils/constants");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const READ_ONLY_FILES = ['sketch.json'];
const READ_ONLY_FILES_REMOTE = ['thingProperties.h', 'thingsProperties.h'];
var CurrentSketch;
(function (CurrentSketch) {
    function isValid(arg) {
        return !!arg && arg !== 'invalid';
    }
    CurrentSketch.isValid = isValid;
})(CurrentSketch = exports.CurrentSketch || (exports.CurrentSketch = {}));
let SketchesServiceClientImpl = class SketchesServiceClientImpl {
    constructor() {
        this.sketches = new Map();
        // TODO: rename this + event to the `onBlabla` pattern
        this.sketchbookDidChangeEmitter = new event_1.Emitter();
        this.onSketchbookDidChange = this.sketchbookDidChangeEmitter.event;
        this.currentSketchDidChangeEmitter = new event_1.Emitter();
        this.onCurrentSketchDidChange = this.currentSketchDidChangeEmitter.event;
        this.toDispose = new disposable_1.DisposableCollection(this.sketchbookDidChangeEmitter, this.currentSketchDidChangeEmitter);
        this.currentSketchLoaded = new promise_util_1.Deferred();
        this.bufferedSketchbookEvents = [];
    }
    onStart() {
        this.configService.getConfiguration().then(({ sketchDirUri }) => {
            this.sketchService
                .getSketches({ uri: sketchDirUri })
                .then((container) => {
                const sketchbookUri = new uri_1.default(sketchDirUri);
                for (const sketch of sketches_service_1.SketchContainer.toArray(container)) {
                    this.sketches.set(sketch.uri, sketch);
                }
                this.toDispose.push(
                // Watch changes in the sketchbook to update `File` > `Sketchbook` menu items.
                this.fileService.watch(new uri_1.default(sketchDirUri), {
                    recursive: true,
                    excludes: [],
                }));
                this.toDispose.push(this.fileService.onDidFilesChange(async (event) => {
                    for (const { type, resource } of event.changes) {
                        // The file change events have higher precedence in the current sketch over the sketchbook.
                        if (CurrentSketch.isValid(this._currentSketch) &&
                            new uri_1.default(this._currentSketch.uri).isEqualOrParent(resource)) {
                            // https://github.com/arduino/arduino-ide/pull/1351#pullrequestreview-1086666656
                            // On a sketch file rename, the FS watcher will contain two changes:
                            //  - Deletion of the original file,
                            //  - Update of the new file,
                            // Hence, `UPDATE` events must be processed but only and if only there is a `DELETED` change in the same event.
                            // Otherwise, IDE2 would ask CLI to reload the sketch content on every save event in IDE2.
                            if (type === 0 /* UPDATED */ &&
                                event.changes.length === 1) {
                                // If the event contains only one `UPDATE` change, it cannot be a rename.
                                return;
                            }
                            let reloadedSketch = undefined;
                            try {
                                reloadedSketch = await this.sketchService.loadSketch(this._currentSketch.uri);
                            }
                            catch (err) {
                                if (!sketches_service_1.SketchesError.NotFound.is(err)) {
                                    throw err;
                                }
                            }
                            if (!reloadedSketch) {
                                return;
                            }
                            if (!protocol_1.Sketch.sameAs(this._currentSketch, reloadedSketch)) {
                                this.useCurrentSketch(reloadedSketch, true);
                            }
                            return;
                        }
                        // We track main sketch files changes only. // TODO: check sketch folder changes. One can rename the folder without renaming the `.ino` file.
                        if (sketchbookUri.isEqualOrParent(resource)) {
                            if (protocol_1.Sketch.isSketchFile(resource)) {
                                if (type === 1 /* ADDED */) {
                                    try {
                                        const toAdd = await this.sketchService.loadSketch(resource.parent.toString());
                                        if (!this.sketches.has(toAdd.uri)) {
                                            console.log(`New sketch '${toAdd.name}' was created in sketchbook '${sketchDirUri}'.`);
                                            this.sketches.set(toAdd.uri, toAdd);
                                            this.fireSoon(toAdd, 'created');
                                        }
                                    }
                                    catch (_a) { }
                                }
                                else if (type === 2 /* DELETED */) {
                                    const uri = resource.parent.toString();
                                    const toDelete = this.sketches.get(uri);
                                    if (toDelete) {
                                        console.log(`Sketch '${toDelete.name}' was removed from sketchbook '${sketchbookUri}'.`);
                                        this.sketches.delete(uri);
                                        this.fireSoon(toDelete, 'removed');
                                    }
                                }
                            }
                        }
                    }
                }));
            });
        });
        this.appStateService
            .reachedState('started_contributions')
            .then(async () => {
            const currentSketch = await this.loadCurrentSketch();
            if (CurrentSketch.isValid(currentSketch)) {
                this.toDispose.pushAll([
                    // Watch the file changes of the current sketch
                    this.fileService.watch(new uri_1.default(currentSketch.uri), {
                        recursive: true,
                        excludes: [],
                    }),
                ]);
            }
            this.useCurrentSketch(currentSketch);
        });
    }
    useCurrentSketch(currentSketch, reassignPromise = false) {
        this._currentSketch = currentSketch;
        if (reassignPromise) {
            this.currentSketchLoaded = new promise_util_1.Deferred();
        }
        this.currentSketchLoaded.resolve(this._currentSketch);
        this.currentSketchDidChangeEmitter.fire(this._currentSketch);
    }
    onStop() {
        this.toDispose.dispose();
    }
    async loadCurrentSketch() {
        const sketches = (await Promise.all(this.workspaceService
            .tryGetRoots()
            .map(({ resource }) => this.sketchService.getSketchFolder(resource.toString())))).filter(objects_1.notEmpty);
        if (!sketches.length) {
            return 'invalid';
        }
        if (sketches.length > 1) {
            console.log(`Multiple sketch folders were found in the workspace. Falling back to the first one. Sketch folders: ${JSON.stringify(sketches)}`);
        }
        return sketches[0];
    }
    async currentSketch() {
        return this.currentSketchLoaded.promise;
    }
    tryGetCurrentSketch() {
        return this._currentSketch;
    }
    async currentSketchFile() {
        const currentSketch = await this.currentSketch();
        if (CurrentSketch.isValid(currentSketch)) {
            return currentSketch.mainFileUri;
        }
        return undefined;
    }
    fireSoon(sketch, type) {
        this.bufferedSketchbookEvents.push({ type, sketch });
        if (typeof this.fireSoonHandle === 'number') {
            window.clearTimeout(this.fireSoonHandle);
        }
        this.fireSoonHandle = window.setTimeout(() => {
            const event = {
                created: [],
                removed: [],
            };
            for (const { type, sketch } of this.bufferedSketchbookEvents) {
                if (type === 'created') {
                    event.created.push(sketch);
                }
                else {
                    event.removed.push(sketch);
                }
            }
            this.sketchbookDidChangeEmitter.fire(event);
            this.bufferedSketchbookEvents.length = 0;
        }, 100);
    }
    /**
     * `true` if the `uri` is not contained in any of the opened workspaces. Otherwise, `false`.
     */
    isReadOnly(uri) {
        var _a;
        const toCheck = uri instanceof uri_1.default ? uri : new uri_1.default(uri);
        if (toCheck.scheme === 'user-storage') {
            return false;
        }
        const isCloudSketch = toCheck
            .toString()
            .includes(`${constants_1.REMOTE_SKETCHBOOK_FOLDER}/${constants_1.ARDUINO_CLOUD_FOLDER}`);
        const filesToCheck = [
            ...READ_ONLY_FILES,
            ...(isCloudSketch ? READ_ONLY_FILES_REMOTE : []),
        ];
        if (filesToCheck.includes((_a = toCheck === null || toCheck === void 0 ? void 0 : toCheck.path) === null || _a === void 0 ? void 0 : _a.base)) {
            return true;
        }
        const readOnly = !this.workspaceService
            .tryGetRoots()
            .some(({ resource }) => resource.isEqualOrParent(toCheck));
        return readOnly;
    }
};
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SketchesServiceClientImpl.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], SketchesServiceClientImpl.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(protocol_1.SketchesService),
    __metadata("design:type", Object)
], SketchesServiceClientImpl.prototype, "sketchService", void 0);
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], SketchesServiceClientImpl.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(config_service_1.ConfigService),
    __metadata("design:type", Object)
], SketchesServiceClientImpl.prototype, "configService", void 0);
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], SketchesServiceClientImpl.prototype, "appStateService", void 0);
SketchesServiceClientImpl = __decorate([
    (0, inversify_1.injectable)()
], SketchesServiceClientImpl);
exports.SketchesServiceClientImpl = SketchesServiceClientImpl;
//# sourceMappingURL=sketches-service-client-impl.js.map