"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronMenuContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const electron_menu_contribution_1 = require("@theia/core/lib/electron-browser/menu/electron-menu-contribution");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const electron_window_preferences_1 = require("@theia/core/lib/electron-browser/window/electron-window-preferences");
const preference_scope_1 = require("@theia/core/lib/browser/preferences/preference-scope");
const remote_1 = require("@theia/core/electron-shared/@electron/remote");
let ElectronMenuContribution = class ElectronMenuContribution extends electron_menu_contribution_1.ElectronMenuContribution {
    // private appReady = false;
    // private updateWhenReady = false;
    onStart(app) {
        super.onStart(app);
        this.appStateService.reachedState('ready').then(() => {
            // this.appReady = true;
            // if (this.updateWhenReady) {
            //   this.update();
            // }
        });
    }
    hideTopPanel() {
        // NOOP
        // We reuse the `div` for the Arduino toolbar.
    }
    update() {
        // if (this.appReady) {
        this.setMenu();
        // } else {
        //   this.updateWhenReady = true;
        // }
    }
    registerCommands(registry) {
        this.theiaRegisterCommands(registry);
        registry.unregisterCommand(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW);
    }
    registerMenus(registry) {
        super.registerMenus(registry);
        registry.unregisterMenuAction(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW);
    }
    registerKeybindings(registry) {
        super.registerKeybindings(registry);
        registry.unregisterKeybinding(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW.id);
        registry.unregisterKeybinding(electron_menu_contribution_1.ElectronCommands.ZOOM_IN.id);
        registry.unregisterKeybinding(electron_menu_contribution_1.ElectronCommands.ZOOM_OUT.id);
    }
    // Copied from Theia: https://github.com/eclipse-theia/theia/blob/9ec8835cf35d5a46101a62ae93285aeb37a2f382/packages/core/src/electron-browser/menu/electron-menu-contribution.ts#L260-L314
    // Unlike the Theia implementation, this does not require synchronously the browser window, but use a function only when the command handler executes.
    theiaRegisterCommands(registry) {
        const currentWindow = () => (0, remote_1.getCurrentWindow)();
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.TOGGLE_DEVELOPER_TOOLS, {
            execute: () => {
                const webContent = (0, remote_1.getCurrentWebContents)();
                if (!webContent.isDevToolsOpened()) {
                    webContent.openDevTools();
                }
                else {
                    webContent.closeDevTools();
                }
            },
        });
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.RELOAD, {
            execute: () => this.windowService.reload(),
        });
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.CLOSE_WINDOW, {
            execute: () => currentWindow().close(),
        });
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.ZOOM_IN, {
            execute: () => {
                const webContents = currentWindow().webContents;
                // When starting at a level that is not a multiple of 0.5, increment by at most 0.5 to reach the next highest multiple of 0.5.
                let zoomLevel = Math.floor(webContents.zoomLevel / electron_window_preferences_1.ZoomLevel.VARIATION) *
                    electron_window_preferences_1.ZoomLevel.VARIATION +
                    electron_window_preferences_1.ZoomLevel.VARIATION;
                if (zoomLevel > electron_window_preferences_1.ZoomLevel.MAX) {
                    zoomLevel = electron_window_preferences_1.ZoomLevel.MAX;
                    return;
                }
                this.preferenceService.set('window.zoomLevel', zoomLevel, preference_scope_1.PreferenceScope.User);
            },
        });
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.ZOOM_OUT, {
            execute: () => {
                const webContents = currentWindow().webContents;
                // When starting at a level that is not a multiple of 0.5, decrement by at most 0.5 to reach the next lowest multiple of 0.5.
                let zoomLevel = Math.ceil(webContents.zoomLevel / electron_window_preferences_1.ZoomLevel.VARIATION) *
                    electron_window_preferences_1.ZoomLevel.VARIATION -
                    electron_window_preferences_1.ZoomLevel.VARIATION;
                if (zoomLevel < electron_window_preferences_1.ZoomLevel.MIN) {
                    zoomLevel = electron_window_preferences_1.ZoomLevel.MIN;
                    return;
                }
                this.preferenceService.set('window.zoomLevel', zoomLevel, preference_scope_1.PreferenceScope.User);
            },
        });
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.RESET_ZOOM, {
            execute: () => this.preferenceService.set('window.zoomLevel', electron_window_preferences_1.ZoomLevel.DEFAULT, preference_scope_1.PreferenceScope.User),
        });
        registry.registerCommand(electron_menu_contribution_1.ElectronCommands.TOGGLE_FULL_SCREEN, {
            isEnabled: () => currentWindow().isFullScreenable(),
            isVisible: () => currentWindow().isFullScreenable(),
            execute: () => currentWindow().setFullScreen(!currentWindow().isFullScreen()),
        });
    }
};
__decorate([
    (0, inversify_1.inject)(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], ElectronMenuContribution.prototype, "appStateService", void 0);
ElectronMenuContribution = __decorate([
    (0, inversify_1.injectable)()
], ElectronMenuContribution);
exports.ElectronMenuContribution = ElectronMenuContribution;
//# sourceMappingURL=electron-menu-contribution.js.map