"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("@theia/core/shared/inversify");
const electron_main_menu_factory_1 = require("@theia/core/lib/electron-browser/menu/electron-main-menu-factory");
const electron_menu_contribution_1 = require("@theia/core/lib/electron-browser/menu/electron-menu-contribution");
const main_menu_manager_1 = require("../../../common/main-menu-manager");
const electron_main_menu_factory_2 = require("./electron-main-menu-factory");
const electron_menu_contribution_2 = require("./electron-menu-contribution");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(electron_menu_contribution_2.ElectronMenuContribution).toSelf().inSingletonScope();
    bind(main_menu_manager_1.MainMenuManager).toService(electron_menu_contribution_2.ElectronMenuContribution);
    rebind(electron_menu_contribution_1.ElectronMenuContribution).toService(electron_menu_contribution_2.ElectronMenuContribution);
    bind(electron_main_menu_factory_2.ElectronMainMenuFactory).toSelf().inSingletonScope();
    rebind(electron_main_menu_factory_1.ElectronMainMenuFactory).toService(electron_main_menu_factory_2.ElectronMainMenuFactory);
});
//# sourceMappingURL=electron-menu-module.js.map