"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const electron_ipc_connection_provider_1 = require("@theia/core/lib/electron-browser/messaging/electron-ipc-connection-provider");
const inversify_1 = require("@theia/core/shared/inversify");
const window_service_ext_1 = require("../../../browser/theia/core/window-service-ext");
const electron_main_window_service_ext_1 = require("../../../electron-common/electron-main-window-service-ext");
const electron_window_service_1 = require("./electron-window-service");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(electron_window_service_1.ElectronWindowService).toSelf().inSingletonScope();
    rebind(window_service_1.WindowService).toService(electron_window_service_1.ElectronWindowService);
    bind(window_service_ext_1.WindowServiceExt).toService(electron_window_service_1.ElectronWindowService);
    bind(electron_main_window_service_ext_1.ElectronMainWindowServiceExt)
        .toDynamicValue(({ container }) => electron_ipc_connection_provider_1.ElectronIpcConnectionProvider.createProxy(container, electron_main_window_service_ext_1.electronMainWindowServiceExtPath))
        .inSingletonScope();
});
//# sourceMappingURL=electron-window-module.js.map